/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.content.signs.demands;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import purplecreate.tramways.Tramways;
import purplecreate.tramways.content.signs.TramSignBlock;
import purplecreate.tramways.content.signs.demands.SignDemand;
import purplecreate.tramways.mixinInterfaces.ISpeedLimitableTrain;

public class SpeedSignDemand
extends SignDemand {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getIcon() {
        return AllBlocks.SPEEDOMETER.asStack();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initSettingsGUI(ModularGuiLineBuilder builder) {
        builder.addScrollInput(0, 34, (si, l) -> {
            si.titled(Tramways.translatable("sign_demand.speed", new Object[0])).withRange(1, 101);
            l.withSuffix("%");
        }, "Throttle");
    }

    @Override
    public void setDefaultSettings(CompoundTag tag) {
        tag.m_128405_("Throttle", 100);
        tag.m_128379_("Overridden", false);
    }

    @Override
    public void validateSettings(CompoundTag received, CompoundTag disk) {
        int nextThrottle = received.m_128451_("Throttle");
        if (nextThrottle >= 1 && nextThrottle <= 100) {
            disk.m_128405_("Throttle", nextThrottle);
        } else {
            disk.m_128405_("Throttle", 100);
        }
    }

    @Override
    public void execute(CompoundTag tag, Train train, double distance) {
        ISpeedLimitableTrain speedLimitableTrain;
        float a;
        double s;
        double u;
        double v;
        ISpeedLimitableTrain speedLimitableTrain2;
        double primaryLimit;
        if (SignDemand.isManual(train)) {
            return;
        }
        double nextThrottle = (double)tag.m_128451_("Throttle") / 100.0;
        if (train instanceof ISpeedLimitableTrain && nextThrottle > (primaryLimit = (speedLimitableTrain2 = (ISpeedLimitableTrain)train).primaryLimit$get())) {
            nextThrottle = primaryLimit;
        }
        if ((v = nextThrottle * (double)train.maxSpeed()) >= (u = Math.abs(train.speed)) ? distance >= 1.0 : distance > Math.abs(s = (v * v - u * u) / (double)(2.0f * (a = train.acceleration())))) {
            return;
        }
        if (train instanceof ISpeedLimitableTrain && (speedLimitableTrain = (ISpeedLimitableTrain)train).tempSpeedLimit$has()) {
            tag.m_128379_("Overridden", true);
            speedLimitableTrain.tempSpeedLimit$updateActual(nextThrottle);
            return;
        }
        tag.m_128379_("Overridden", false);
        train.throttle = nextThrottle;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(TramSignBlock.SignType signType, CompoundTag tag, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        SignDemand.renderTextInCenter("" + tag.m_128451_("Throttle"), 0, 0.025f, ms, buffer, light);
        if (tag.m_128471_("Overridden")) {
            ms.m_85837_(0.0, 0.0, 0.001);
            SignDemand.renderTextInCenter("\u2014", 14427686, 0.0625f, ms, buffer, light);
        }
    }
}

