/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.content.stationDeco.nameSign;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.simibubi.create.foundation.model.BakedModelHelper;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import java.util.Objects;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.render.SuperBufferFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Display;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import purplecreate.tramways.TPartialModels;
import purplecreate.tramways.content.stationDeco.nameSign.NameSignBlock;
import purplecreate.tramways.content.stationDeco.nameSign.NameSignBlockEntity;
import purplecreate.tramways.content.stationDeco.nameSign.info.NameSignInfo;

@OnlyIn(value=Dist.CLIENT)
public class NameSignRenderer
extends SmartBlockEntityRenderer<NameSignBlockEntity> {
    private static final PartialModel woodenInnerA = TPartialModels.SIGN_WOODEN_INNER_A;
    private static final PartialModel woodenInnerB = TPartialModels.SIGN_WOODEN_INNER_B;

    public NameSignRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    private TextureAtlasSprite getSpriteOnSide(BlockState state, Direction side) {
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state);
        if (model == null) {
            return null;
        }
        RandomSource random = RandomSource.m_216327_();
        random.m_188584_(42L);
        List quads = model.m_213637_(state, side, random);
        if (!quads.isEmpty()) {
            return ((BakedQuad)quads.get(0)).m_173410_();
        }
        random.m_188584_(42L);
        quads = model.m_213637_(state, null, random);
        if (!quads.isEmpty()) {
            for (BakedQuad quad : quads) {
                if (quad.m_111306_() != side) continue;
                return quad.m_173410_();
            }
        }
        return model.m_6160_();
    }

    public static void renderText(NameSignInfo.Entry nameSignInfo, List<String> lines, PoseStack ms, MultiBufferSource buffer, int light, boolean renderOnBlock) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        if (renderOnBlock) {
            float scale = 0.01f;
            float tx = switch (nameSignInfo.align()) {
                default -> throw new IncompatibleClassChangeError();
                case Display.TextDisplay.Align.LEFT -> 0.0f;
                case Display.TextDisplay.Align.RIGHT -> 1.0f;
                case Display.TextDisplay.Align.CENTER -> 0.5f;
            };
            ms.m_85837_((double)tx, 0.5, 0.0);
            ms.m_85841_(scale, -scale, scale);
            ms.m_85837_((double)tx, 0.5, 0.0);
        }
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            float x = switch (nameSignInfo.align()) {
                default -> throw new IncompatibleClassChangeError();
                case Display.TextDisplay.Align.LEFT -> nameSignInfo.offset();
                case Display.TextDisplay.Align.RIGHT -> -nameSignInfo.offset();
                case Display.TextDisplay.Align.CENTER -> (float)fontRenderer.m_92895_(line) / -2.0f + (float)nameSignInfo.offset();
            };
            Objects.requireNonNull(fontRenderer);
            float f = i * 9;
            int n = lines.size();
            Objects.requireNonNull(fontRenderer);
            float y = f - (float)(n * 9) / 2.0f;
            fontRenderer.m_271703_(line, x, y, nameSignInfo.color().m_41071_(), false, ms.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, light);
        }
    }

    private void renderWoodenInner(BlockState wood, BlockState ref, Direction direction, int light, PoseStack ms, MultiBufferSource buffer) {
        BakedModel modelA = BakedModelHelper.generateModel((BakedModel)woodenInnerA.get(), s -> this.getSpriteOnSide(wood, Direction.UP));
        SuperBufferFactory.getInstance().createForBlock(modelA, ref).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        ms.m_85836_();
        ((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)ms).center()).rotateYDegrees(AngleHelper.horizontalAngle((Direction)direction))).uncenter();
        BakedModel modelB = BakedModelHelper.generateModel((BakedModel)woodenInnerB.get(), s -> this.getSpriteOnSide(wood, Direction.UP));
        SuperBufferFactory.getInstance().createForBlock(modelB, ref).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        ms.m_85849_();
    }

    protected void renderSafe(NameSignBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState state = be.m_58900_();
        Direction facing = (Direction)state.m_61143_((Property)NameSignBlock.f_54117_);
        boolean extended = (Boolean)state.m_61143_((Property)NameSignBlock.EXTENDED);
        NameSignInfo.Entry nameSignInfo = NameSignInfo.get(CatnipServices.REGISTRIES.getKeyOrThrow(state.m_60734_()));
        this.renderWoodenInner(be.wood, be.m_58900_(), facing, light, ms, buffer);
        if (extended && facing.m_122421_() == Direction.AxisDirection.NEGATIVE) {
            return;
        }
        for (Direction direction : List.of(facing, facing.m_122424_())) {
            ms.m_85836_();
            float extendedTranslation = direction == facing ? 0.5f : -0.5f;
            ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)ms).center()).rotateYDegrees(AngleHelper.horizontalAngle((Direction)direction))).uncenter()).translate(extended ? (double)extendedTranslation : 0.0, 0.0, 0.688125);
            NameSignRenderer.renderText(nameSignInfo.forceCenteredIf(extended), be.getLinesSafe(), ms, buffer, light, true);
            ms.m_85849_();
        }
    }
}

