/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.content.stationDeco.nameSign.info;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Display;
import net.minecraft.world.item.DyeColor;
import org.slf4j.Logger;
import purplecreate.tramways.Tramways;

public class NameSignInfo
implements ResourceManagerReloadListener {
    private static final Map<ResourceLocation, Entry> infoMap = new HashMap<ResourceLocation, Entry>();
    public static final String infoDirectory = "tramways_name_sign";
    public static final NameSignInfo listener = new NameSignInfo();

    public void m_6213_(ResourceManager manager) {
        infoMap.clear();
        FileToIdConverter.m_246568_((String)infoDirectory).m_247457_(manager).forEach((location, resource) -> {
            String[] pathParts = location.m_135815_().split("/");
            ResourceLocation id = new ResourceLocation(location.m_135827_(), pathParts[pathParts.length - 1].replace(".json", ""));
            try (BufferedReader reader = resource.m_215508_();){
                JsonObject obj = GsonHelper.m_13859_((Reader)reader);
                infoMap.put(id, (Entry)Entry.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)obj).resultOrPartial(arg_0 -> ((Logger)Tramways.LOGGER).error(arg_0)).orElseThrow());
                Tramways.LOGGER.info("Loaded name sign info for {}", (Object)id);
            }
            catch (Exception e) {
                Tramways.LOGGER.error("Couldn't load name sign info for {}", (Object)id, (Object)e);
            }
        });
    }

    public static Entry get(ResourceLocation location) {
        return infoMap.getOrDefault(location, Entry.DEFAULT);
    }

    public record Entry(Display.TextDisplay.Align align, int offset, DyeColor color) {
        public static final Entry DEFAULT = new Entry(Display.TextDisplay.Align.CENTER, 0, DyeColor.BLACK);
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Display.TextDisplay.Align.f_268461_.fieldOf("align").forGetter(Entry::align), (App)Codec.INT.fieldOf("offset").forGetter(Entry::offset), (App)DyeColor.f_262211_.fieldOf("color").forGetter(Entry::color)).apply((Applicative)instance, Entry::new));

        public Entry forceCentered() {
            return new Entry(Display.TextDisplay.Align.CENTER, this.offset, this.color);
        }

        public Entry forceCenteredIf(boolean value) {
            return value ? this.forceCentered() : this;
        }
    }
}

