/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.content.stationDeco.nameSign.info;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Display;
import net.minecraft.world.item.DyeColor;
import org.slf4j.Logger;
import purplecreate.tramways.Tramways;
import purplecreate.tramways.content.stationDeco.nameSign.info.NameSignInfo;

public abstract class NameSignInfoProvider
implements DataProvider {
    private final PackOutput.PathProvider path;
    private final Map<ResourceLocation, NameSignInfo.Entry> toRegister = new HashMap<ResourceLocation, NameSignInfo.Entry>();

    public NameSignInfoProvider(PackOutput output) {
        this.path = output.m_245269_(PackOutput.Target.RESOURCE_PACK, "tramways_name_sign");
    }

    protected abstract void createData();

    public Builder builder() {
        return new Builder();
    }

    public void add(BlockEntry<?> blockEntry, NameSignInfo.Entry entry) {
        this.toRegister.put(blockEntry.getId(), entry);
    }

    public void add(ResourceLocation location, NameSignInfo.Entry entry) {
        this.toRegister.put(location, entry);
    }

    public CompletableFuture<?> m_213708_(CachedOutput output) {
        this.toRegister.clear();
        this.createData();
        return CompletableFuture.allOf((CompletableFuture[])this.toRegister.entrySet().stream().map(entry -> DataProvider.m_253162_((CachedOutput)output, (JsonElement)((JsonElement)NameSignInfo.Entry.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((NameSignInfo.Entry)entry.getValue())).resultOrPartial(arg_0 -> ((Logger)Tramways.LOGGER).error(arg_0)).orElseThrow()), (Path)this.path.m_245731_((ResourceLocation)entry.getKey()))).toArray(CompletableFuture[]::new));
    }

    public String m_6055_() {
        return "Tramways: Name Sign Info";
    }

    public class Builder {
        private Display.TextDisplay.Align align = NameSignInfo.Entry.DEFAULT.align();
        private int offset = NameSignInfo.Entry.DEFAULT.offset();
        private DyeColor color = NameSignInfo.Entry.DEFAULT.color();

        public Builder align(Display.TextDisplay.Align align) {
            this.align = align;
            return this;
        }

        public Builder offset(int offset) {
            this.offset = offset;
            return this;
        }

        public Builder color(DyeColor color) {
            this.color = color;
            return this;
        }

        public NameSignInfo.Entry build() {
            return new NameSignInfo.Entry(this.align, this.offset, this.color);
        }

        public void register(BlockEntry<?> ... blockEntries) {
            for (BlockEntry<?> blockEntry : blockEntries) {
                NameSignInfoProvider.this.add(blockEntry, this.build());
            }
        }

        public void register(ResourceLocation ... locations) {
            for (ResourceLocation location : locations) {
                NameSignInfoProvider.this.add(location, this.build());
            }
        }
    }
}

