/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.mixins;

import com.simibubi.create.content.trains.entity.Navigation;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.schedule.Schedule;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import com.simibubi.create.content.trains.station.GlobalStation;
import java.util.List;
import java.util.UUID;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Pair;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import purplecreate.tramways.content.requestStop.RequestStopServer;
import purplecreate.tramways.content.requestStop.train.RequestStopInstruction;
import purplecreate.tramways.content.signs.TramSignPoint;
import purplecreate.tramways.mixinInterfaces.IStopRequestableNavigation;

@Mixin(value={Navigation.class}, remap=false)
public abstract class NavigationMixin
implements IStopRequestableNavigation {
    @Unique
    private boolean tramways$routeCancelled;
    @Shadow
    public Train train;
    @Shadow
    public double distanceToDestination;
    @Shadow
    public double distanceStartedAt;
    @Shadow
    private List<Couple<TrackNode>> currentPath;
    @Shadow
    public GlobalStation destination;

    @Unique
    private void tramways$cancelRoute() {
        this.currentPath.clear();
        if (this.destination != null) {
            this.destination.cancelReservation(this.train);
            this.destination = null;
        }
        this.train.runtime.state = ScheduleRuntime.State.PRE_TRANSIT;
        ++this.train.runtime.currentEntry;
    }

    @Override
    @Unique
    public void tramways$resetRouteCancelled() {
        this.tramways$routeCancelled = false;
    }

    @Inject(method={"lambda$tick$0"}, at={@At(value="HEAD")})
    private void tramways$tickSign(MutableObject<Pair<UUID, Boolean>> trackingCrossSignal, double scanDistance, MutableDouble crossSignalDistanceTracker, double brakingDistanceNoFlicker, Double distance, Pair<TrackEdgePoint, Couple<TrackNode>> couple, CallbackInfoReturnable<Boolean> cir) {
        Object object = couple.getFirst();
        if (object instanceof TramSignPoint) {
            TramSignPoint sign = (TramSignPoint)((Object)object);
            TrackNode node = (TrackNode)((Couple)couple.getSecond()).getSecond();
            sign.updateTrain(this.train, node, distance);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tramways$tickRequestStop(Level level, CallbackInfo ci) {
        Schedule schedule = this.train.runtime.getSchedule();
        if (this.train.runtime.paused || schedule == null || this.train.runtime.currentEntry >= schedule.entries.size()) {
            return;
        }
        double acceleration = this.train.acceleration();
        double brakingDistance = this.train.speed * this.train.speed / (2.0 * acceleration);
        ScheduleEntry currentEntry = (ScheduleEntry)schedule.entries.get(this.train.runtime.currentEntry);
        if (!(currentEntry.instruction instanceof RequestStopInstruction) || this.distanceToDestination < 1.0) {
            return;
        }
        if (this.distanceToDestination <= brakingDistance) {
            if (!RequestStopServer.shouldStop(this.train) && !this.tramways$routeCancelled) {
                this.tramways$cancelRoute();
                this.tramways$routeCancelled = true;
            }
            RequestStopServer.removeCountdown(this.train);
        } else if (!RequestStopServer.shouldStop(this.train)) {
            RequestStopServer.updateCountdown(this.train, (float)((this.distanceToDestination - brakingDistance) / (this.distanceStartedAt - brakingDistance)));
        }
    }
}

