/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.ponder;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.decoration.girder.GirderBlock;
import com.simibubi.create.content.trains.signal.SignalBlockEntity;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.element.ParrotPose;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.api.scene.Selection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import purplecreate.tramways.TBlocks;
import purplecreate.tramways.content.signals.TramSignalBlock;
import purplecreate.tramways.content.signals.TramSignalState;
import purplecreate.tramways.content.signs.TramSignBlock;

public class TramSignalScenes {
    private static void setTramSignalState(SceneBuilder scene, BlockPos tramSignal, TramSignalState next) {
        scene.world().modifyBlock(tramSignal, state -> (BlockState)state.m_61124_(TramSignalBlock.STATE, (Comparable)((Object)next)), false);
    }

    public static void trackSignals(SceneBuilder _scene, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(_scene);
        scene.title("tram_signals", "Tram Signals with Track Signals");
        scene.scaleSceneView(0.6f);
        scene.showBasePlate();
        BlockPos tramSignal = new BlockPos(7, 3, 4);
        BlockPos girder = new BlockPos(7, 2, 4);
        BlockPos trackSignal = new BlockPos(7, 1, 4);
        Selection train = util.select().fromTo(7, 2, 6, 7, 3, 7);
        for (int i = 0; i < 9; ++i) {
            scene.world().showSection(util.select().position(4, 1, i), Direction.DOWN);
            scene.idle(1);
        }
        scene.world().showSection(util.select().position(trackSignal), Direction.DOWN);
        scene.idle(1);
        scene.world().showSection(util.select().position(girder), Direction.DOWN);
        scene.idle(1);
        scene.world().showSection(util.select().position(tramSignal), Direction.DOWN);
        scene.idle(20);
        scene.overlay().showText(60).pointAt(util.vector().topOf(tramSignal)).text("Tram Signals can be placed on track signals to display the signal's state");
        scene.idle(80);
        scene.overlay().showText(60).pointAt(util.vector().centerOf(girder)).attachKeyFrame().text("They can be placed with different types of pole between the tram and track signal");
        scene.world().setBlock(girder, Blocks.f_50479_.m_49966_(), true);
        scene.idle(20);
        scene.world().setBlock(girder, (BlockState)((TramSignBlock)((Object)TBlocks.TRAM_SIGN.get())).m_49966_().m_61124_((Property)TramSignBlock.f_54117_, (Comparable)Direction.WEST), true);
        scene.idle(20);
        scene.world().setBlock(girder, ((GirderBlock)AllBlocks.METAL_GIRDER.get()).m_49966_(), true);
        scene.idle(40);
        ElementLink trainElement = scene.world().showIndependentSection(train, null);
        ElementLink birbElement = scene.special().createBirb(util.vector().centerOf(4, 3, 0), ParrotPose.FacePointOfInterestPose::new);
        scene.world().moveSection(trainElement, util.vector().of(-3.0, 0.0, -6.0), 0);
        scene.overlay().showText(60).pointAt(util.vector().topOf(tramSignal)).attachKeyFrame().text("When a train occupies the signal block...");
        scene.idle(80);
        scene.world().moveSection(trainElement, util.vector().of(0.0, 0.0, 6.0), 30);
        scene.special().moveParrot(birbElement, util.vector().of(0.0, 0.0, 6.0), 30);
        scene.idle(10);
        scene.world().changeSignalState(trackSignal, SignalBlockEntity.SignalState.RED);
        TramSignalScenes.setTramSignalState((SceneBuilder)scene, tramSignal, TramSignalState.STOP);
        scene.idle(10);
        scene.overlay().showText(60).pointAt(util.vector().topOf(tramSignal)).text("...the tram signal changes to a horizontal line");
        scene.idle(80);
    }
}

