/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways;

import dev.architectury.injectables.annotations.ExpectPlatform;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import purplecreate.tramways.content.announcements.network.PlayMovingVoiceS2CPacket;
import purplecreate.tramways.content.announcements.network.PlayVoiceS2CPacket;
import purplecreate.tramways.content.requestStop.network.RequestStopC2SPacket;
import purplecreate.tramways.content.requestStop.network.StoppingBroadcastS2CPacket;
import purplecreate.tramways.content.signs.network.SaveSignSettingsC2SPacket;
import purplecreate.tramways.content.stationDeco.nameSign.network.UpdateNameSignC2SPacket;
import purplecreate.tramways.fabric.TNetworkingImpl;
import purplecreate.tramways.util.C2SPacket;
import purplecreate.tramways.util.S2CPacket;

public class TNetworking {
    private static final String VERSION = "4";
    private static int id = 0;
    private static Map<Class<? extends C2SPacket>, Integer> c2sIdentifiers = new HashMap<Class<? extends C2SPacket>, Integer>();
    private static Map<Class<? extends S2CPacket>, Integer> s2cIdentifiers = new HashMap<Class<? extends S2CPacket>, Integer>();
    private static Map<Integer, Function<class_2540, ? extends C2SPacket>> c2sReaders = new HashMap<Integer, Function<class_2540, ? extends C2SPacket>>();
    private static Map<Integer, Function<class_2540, ? extends S2CPacket>> s2cReaders = new HashMap<Integer, Function<class_2540, ? extends S2CPacket>>();

    private static <T extends S2CPacket> void registerS2C(Class<T> clazz, Function<class_2540, T> read) {
        int packetId = id++;
        s2cIdentifiers.put(clazz, packetId);
        s2cReaders.put(packetId, read);
    }

    private static <T extends C2SPacket> void registerC2S(Class<T> clazz, Function<class_2540, T> read) {
        int packetId = id++;
        c2sIdentifiers.put(clazz, packetId);
        c2sReaders.put(packetId, read);
    }

    public static <T extends C2SPacket> void sendInternal(T message, Consumer<class_2540> consumer) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10804(c2sIdentifiers.get(message.getClass()).intValue());
        message.write(buf);
        consumer.accept(buf);
    }

    public static <T extends S2CPacket> void sendInternal(T message, Consumer<class_2540> consumer) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10804(s2cIdentifiers.get(message.getClass()).intValue());
        message.write(buf);
        consumer.accept(buf);
    }

    public static void handleInternal(class_2540 buf, class_310 mc) {
        int packetId = buf.method_10816();
        S2CPacket packet = s2cReaders.get(packetId).apply(buf);
        mc.execute(() -> packet.handle(mc));
    }

    public static void handleInternal(class_2540 buf, class_3222 player) {
        int packetId = buf.method_10816();
        C2SPacket packet = c2sReaders.get(packetId).apply(buf);
        player.field_13995.execute(() -> packet.handle(player));
    }

    public static void onPlayerJoin(class_3222 player) {
        TNetworking.sendToPlayer(new CheckVersionS2CPacket(VERSION), player);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends S2CPacket> void sendToAll(T message) {
        TNetworkingImpl.sendToAll(message);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends S2CPacket> void sendToNear(T message, class_243 pos, int range, class_5321<class_1937> dimension) {
        void var3_3;
        void var2_2;
        void var1_1;
        TNetworkingImpl.sendToNear(message, (class_243)var1_1, (int)var2_2, (class_5321<class_1937>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends S2CPacket> void sendToPlayer(T message, class_3222 player) {
        void var1_1;
        TNetworkingImpl.sendToPlayer(message, (class_3222)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends C2SPacket> void sendToServer(T message) {
        TNetworkingImpl.sendToServer(message);
    }

    public static void register() {
        TNetworking.registerS2C(CheckVersionS2CPacket.class, CheckVersionS2CPacket::read);
        TNetworking.registerS2C(PlayVoiceS2CPacket.class, PlayVoiceS2CPacket::read);
        TNetworking.registerS2C(PlayMovingVoiceS2CPacket.class, PlayMovingVoiceS2CPacket::read);
        TNetworking.registerC2S(SaveSignSettingsC2SPacket.class, SaveSignSettingsC2SPacket::read);
        TNetworking.registerC2S(RequestStopC2SPacket.class, RequestStopC2SPacket::read);
        TNetworking.registerS2C(StoppingBroadcastS2CPacket.class, StoppingBroadcastS2CPacket::read);
        TNetworking.registerC2S(UpdateNameSignC2SPacket.class, UpdateNameSignC2SPacket::read);
    }

    private static class CheckVersionS2CPacket
    implements S2CPacket {
        private final String serverVersion;

        public CheckVersionS2CPacket(String serverVersion) {
            this.serverVersion = serverVersion;
        }

        public static CheckVersionS2CPacket read(class_2540 buf) {
            return new CheckVersionS2CPacket(buf.method_19772());
        }

        @Override
        public void write(class_2540 buf) {
            buf.method_10814(this.serverVersion);
        }

        @Override
        public void handle(class_310 mc) {
            if (TNetworking.VERSION.equals(this.serverVersion)) {
                return;
            }
            mc.method_1562().method_10839((class_2561)class_2561.method_43470((String)"Create: Tramways network versions do not match! Server expected %s, client has %s".formatted(this.serverVersion, TNetworking.VERSION)));
        }
    }
}

