/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import purplecreate.tramways.config.MessageConfig;
import purplecreate.tramways.config.StationConfig;
import purplecreate.tramways.config.TrainConfig;

public class Config {
    private static Config instance;
    public static final Gson gson;
    private static final File file;
    private Map<String, TrainConfig> trains = null;
    private Map<String, StationConfig> stations = null;

    public static Config getInstance() {
        if (instance == null) {
            return Config.reload();
        }
        return instance;
    }

    private <T> T find(Supplier<T> create, Map<String, T> map, String name) {
        if (!Objects.isNull(map)) {
            for (Map.Entry<String, T> entry : map.entrySet()) {
                String filter = entry.getKey();
                Object regex = filter.isBlank() ? filter : "\\Q" + filter.replace("*", "\\E.*\\Q") + "\\E";
                if (!name.matches((String)regex)) continue;
                return entry.getValue();
            }
        }
        return create.get();
    }

    public TrainConfig findTrain(String trainName) {
        return this.find(TrainConfig::new, this.trains, trainName);
    }

    public StationConfig findStation(String stationName) {
        return this.find(StationConfig::new, this.stations, stationName);
    }

    public void write() throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        try (FileWriter writer = new FileWriter(file);){
            gson.toJson((Object)this, (Appendable)writer);
        }
    }

    public static Config reload() {
        Config config;
        try (FileReader reader = new FileReader(file);){
            config = (Config)gson.fromJson((Reader)reader, Config.class);
            if (config == null) {
                config = new Config();
            }
        }
        catch (IOException e) {
            config = new Config();
        }
        if (config.trains == null) {
            config.trains = new HashMap<String, TrainConfig>();
            config.trains.put("*", TrainConfig.getInitial());
        }
        if (config.stations == null) {
            config.stations = new HashMap<String, StationConfig>();
            config.stations.put("*", StationConfig.getInitial());
        }
        instance = config;
        return config;
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().serializeNulls().registerTypeAdapter(MessageConfig.class, (Object)new MessageConfig()).create();
        file = new File("config", "tramways-config.json");
    }
}

