/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import purplecreate.tramways.config.MessageConfig;
import purplecreate.tramways.config.StationMessageType;

public class StationConfig {
    private String alias = null;
    private String extra = null;
    private String announcer = null;
    private Map<StationMessageType, List<MessageConfig>> messages = null;

    public static StationConfig getInitial() {
        StationConfig stationConfig = new StationConfig();
        stationConfig.announcer = stationConfig.getAnnouncer();
        stationConfig.messages = new HashMap<StationMessageType, List<MessageConfig>>();
        for (StationMessageType type : (StationMessageType[])StationMessageType.class.getEnumConstants()) {
            stationConfig.messages.put(type, stationConfig.getMessages(type));
        }
        return stationConfig;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getExtra() {
        return this.extra;
    }

    public String getAnnouncer() {
        if (Objects.isNull(this.announcer)) {
            return "en-GB-SoniaNeural";
        }
        return this.announcer;
    }

    public List<MessageConfig> getMessages(StationMessageType type) {
        if (Objects.isNull(this.messages)) {
            return List.of(MessageConfig.simple(type.defaultString));
        }
        List<MessageConfig> msgs = this.messages.getOrDefault((Object)type, List.of());
        if (msgs.isEmpty()) {
            return List.of(MessageConfig.simple(type.defaultString));
        }
        return msgs;
    }

    public MessageConfig getRandomMessage(StationMessageType type) {
        List<MessageConfig> msgs = this.getMessages(type);
        return msgs.get(new Random().nextInt(msgs.size()));
    }
}

