/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.content.announcements.network;

import com.simibubi.create.Create;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_4234;
import net.minecraft.class_638;
import purplecreate.tramways.Tramways;
import purplecreate.tramways.config.MessageConfig;
import purplecreate.tramways.content.announcements.network.PacketHandler;
import purplecreate.tramways.content.announcements.sound.MinimalSoundEngine;
import purplecreate.tramways.content.announcements.sound.MovingVoiceSoundInstance;
import purplecreate.tramways.util.S2CPacket;

public class PlayMovingVoiceS2CPacket
implements S2CPacket {
    final String voice;
    final MessageConfig content;
    final class_2338 localPos;
    final UUID trainId;
    final int carriageId;

    public PlayMovingVoiceS2CPacket(String voice, MessageConfig content, class_2338 localPos, Carriage carriage) {
        this(voice, content, localPos, carriage.train.id, carriage.train.carriages.indexOf(carriage));
    }

    public PlayMovingVoiceS2CPacket(String voice, MessageConfig content, class_2338 localPos, UUID trainId, int carriageId) {
        this.voice = voice;
        this.content = content;
        this.localPos = localPos;
        this.trainId = trainId;
        this.carriageId = carriageId;
    }

    public static PlayMovingVoiceS2CPacket read(class_2540 buffer) {
        String voice = buffer.method_19772();
        MessageConfig content = MessageConfig.readBytes(buffer);
        class_2338 localPos = buffer.method_10811();
        UUID trainId = buffer.method_10790();
        int carriageId = buffer.method_10816();
        return new PlayMovingVoiceS2CPacket(voice, content, localPos, trainId, carriageId);
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10814(this.voice);
        this.content.writeBytes(buffer);
        buffer.method_10807(this.localPos);
        buffer.method_10797(this.trainId);
        buffer.method_10804(this.carriageId);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void handle(class_310 mc) {
        class_638 level = mc.field_1687;
        Train train = (Train)Create.RAILWAYS.sided((class_1936)level).trains.get(this.trainId);
        if (train == null) {
            Tramways.LOGGER.warn("Couldn't play voice: Requested train is null");
            return;
        }
        Carriage carriage = (Carriage)train.carriages.get(this.carriageId);
        if (carriage == null) {
            Tramways.LOGGER.warn("Couldn't play voice: Requested carriage is null");
            return;
        }
        class_4234 audioStream = PacketHandler.getAudioStream(this.voice, this.content);
        if (audioStream != null) {
            MinimalSoundEngine.play((class_1113)MovingVoiceSoundInstance.create(audioStream, carriage, this.localPos));
        }
    }
}

