/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.content.requestStop;

import com.simibubi.create.content.trains.entity.Train;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import purplecreate.tramways.TNetworking;
import purplecreate.tramways.content.requestStop.network.StoppingBroadcastS2CPacket;

public class RequestStopServer {
    private static final Map<Train, Float> countdowns = new HashMap<Train, Float>();
    private static final Set<Train> stopping = new HashSet<Train>();

    public static void request(Train train) {
        if (stopping.contains(train) || !countdowns.containsKey(train)) {
            return;
        }
        stopping.add(train);
        countdowns.remove(train);
        RequestStopServer.notifyPassengers(train);
    }

    public static void removeRequest(Train train) {
        if (!stopping.contains(train)) {
            return;
        }
        stopping.remove(train);
        RequestStopServer.notifyPassengers(train);
    }

    public static void updateCountdown(Train train, float countdown) {
        countdowns.put(train, Float.valueOf(countdown));
        RequestStopServer.notifyPassengers(train);
    }

    public static void removeCountdown(Train train) {
        if (!countdowns.containsKey(train)) {
            return;
        }
        countdowns.remove(train);
        RequestStopServer.notifyPassengers(train);
    }

    public static boolean shouldStop(Train train) {
        return stopping.contains(train);
    }

    private static void notifyPassengers(Train train) {
        train.carriages.forEach(carriage -> carriage.forEachPresentEntity(cce -> cce.method_5736().forEach(entity -> {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                RequestStopServer.notifyPassenger(train, player);
            }
        })));
    }

    private static void notifyPassenger(Train train, class_1657 player) {
        if (player instanceof class_3222) {
            StoppingBroadcastS2CPacket.Type type;
            class_3222 serverPlayer = (class_3222)player;
            float progress = 0.0f;
            if (stopping.contains(train)) {
                type = StoppingBroadcastS2CPacket.Type.SHOW_STOPPING;
            } else if (countdowns.containsKey(train)) {
                type = StoppingBroadcastS2CPacket.Type.UPDATE_COUNTDOWN;
                progress = countdowns.get(train).floatValue();
            } else {
                type = StoppingBroadcastS2CPacket.Type.REMOVE;
            }
            TNetworking.sendToPlayer(new StoppingBroadcastS2CPacket(type, progress, train.navigation.destination == null ? "?" : train.navigation.destination.name), serverPlayer);
        }
    }
}

