/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.content.signs;

import com.simibubi.create.api.contraption.transformable.TransformableBlockEntity;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.trains.signal.SignalBlockEntity;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import purplecreate.tramways.TExtras;
import purplecreate.tramways.Tramways;
import purplecreate.tramways.content.signs.TramSignBlock;
import purplecreate.tramways.content.signs.TramSignPoint;
import purplecreate.tramways.content.signs.demands.SignDemand;

public class TramSignBlockEntity
extends SmartBlockEntity
implements TransformableBlockEntity {
    TrackTargetingBehaviour<TramSignPoint> edgePoint;
    private static final class_2960 DEFAULT_DEMAND_ID = Tramways.rl("speed");
    private static final class_2960 DEFAULT_AUX_DEMAND_ID = Tramways.rl("advance_warning_aux");
    private SignDemand demand = SignDemand.demands.get(this.getSignType() == TramSignBlock.SignType.AUXILIARY ? DEFAULT_AUX_DEMAND_ID : DEFAULT_DEMAND_ID);
    private class_2487 demandExtra = new class_2487();
    private SignalBlockEntity.OverlayState overlay;

    public TramSignBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.demand.setDefaultSettings(this.demandExtra);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.edgePoint = new TrackTargetingBehaviour((SmartBlockEntity)this, TExtras.EdgePointTypes.TRAM_SIGN);
        behaviours.add((BlockEntityBehaviour)this.edgePoint);
    }

    public void transform(class_2586 be, StructureTransform transform) {
        this.edgePoint.transform(be, transform);
    }

    public SignDemand getDemand() {
        return this.demand;
    }

    public class_2487 getDemandExtra() {
        return this.demandExtra;
    }

    public TramSignBlock.SignType getSignType() {
        class_2248 block = this.method_11010().method_26204();
        if (block instanceof TramSignBlock) {
            return ((TramSignBlock)block).signType;
        }
        return TramSignBlock.SignType.TRAM;
    }

    public SignalBlockEntity.OverlayState getOverlay() {
        return this.overlay;
    }

    public void setDemand(class_2960 id) {
        class_2960 lastId = this.demand != null ? this.demand.id : null;
        this.demand = SignDemand.demands.get(SignDemand.demands.containsKey(id) ? id : DEFAULT_DEMAND_ID);
        if (!this.demand.id.equals((Object)lastId)) {
            this.demandExtra = new class_2487();
            this.demand.setDefaultSettings(this.demandExtra);
        }
        this.notifyUpdate();
        this.updatePoint();
    }

    public void setDemandExtra(class_2487 received) {
        if (this.demand == null) {
            return;
        }
        class_2487 disk = new class_2487();
        this.demand.validateSettings(received, disk);
        this.demandExtra = disk;
        this.notifyUpdate();
        this.updatePoint();
    }

    private void updatePoint() {
        TramSignPoint point = (TramSignPoint)this.edgePoint.getEdgePoint();
        if (point != null) {
            point.updateSignData(this.field_11867, this.demand, this.demandExtra);
        }
    }

    public void setOverlay(SignalBlockEntity.OverlayState overlay) {
        if (this.overlay == overlay) {
            return;
        }
        this.overlay = overlay;
        this.notifyUpdate();
    }

    public void tick() {
        super.tick();
        if (this.field_11863.field_9236) {
            return;
        }
        TramSignPoint point = (TramSignPoint)this.edgePoint.getEdgePoint();
        if (point == null) {
            this.setOverlay(SignalBlockEntity.OverlayState.RENDER);
            return;
        }
        this.setOverlay(point.getOverlayFor(this.field_11867));
        TramSignPoint.SignData data = point.getSignData(this.field_11867);
        if (data.demand != this.demand || data.demandExtra != this.demandExtra) {
            this.demand = data.demand;
            this.demandExtra = data.demandExtra;
            this.notifyUpdate();
        }
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.overlay = (SignalBlockEntity.OverlayState)NBTHelper.readEnum((class_2487)tag, (String)"Overlay", SignalBlockEntity.OverlayState.class);
        if (tag.method_10545("Demand")) {
            this.demand = SignDemand.demands.get(NBTHelper.readResourceLocation((class_2487)tag, (String)"Demand"));
        }
        if (tag.method_10545("DemandExtra")) {
            this.demandExtra = tag.method_10562("DemandExtra");
        } else {
            this.demandExtra = new class_2487();
            this.demand.setDefaultSettings(this.demandExtra);
        }
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        NBTHelper.writeEnum((class_2487)tag, (String)"Overlay", (Enum)(this.overlay == null ? SignalBlockEntity.OverlayState.SKIP : this.overlay));
        if (this.demand != null) {
            NBTHelper.writeResourceLocation((class_2487)tag, (String)"Demand", (class_2960)this.demand.id);
        }
        if (this.demandExtra != null) {
            tag.method_10566("DemandExtra", (class_2520)this.demandExtra);
        }
    }

    protected class_238 createRenderBoundingBox() {
        return new class_238(this.field_11867, this.edgePoint.getGlobalPosition()).method_1014(2.0);
    }
}

