/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.content.signs;

import com.simibubi.create.Create;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.signal.SignalBlockEntity;
import com.simibubi.create.content.trains.signal.SignalPropagator;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import purplecreate.tramways.TBlockEntities;
import purplecreate.tramways.Tramways;
import purplecreate.tramways.content.signs.TramSignBlockEntity;
import purplecreate.tramways.content.signs.demands.SignDemand;

public class TramSignPoint
extends TrackEdgePoint {
    private Couple<Set<SignData>> sides = Couple.create(HashSet::new);
    private final Couple<Map<Train, Double>> queue = Couple.create(HashMap::new);

    public void updateTrain(Train train, TrackNode node, double distance) {
        ((Map)this.queue.get(this.isPrimary(node))).put(train, distance);
    }

    public void removeTrain(Train train, TrackNode node) {
        ((Map)this.queue.get(this.isPrimary(node))).remove(train);
    }

    public SignData getSignData(class_2338 pos) {
        for (boolean front : Iterate.trueAndFalse) {
            for (SignData sign : (Set)this.sides.get(front)) {
                if (!sign.pos.equals((Object)pos)) continue;
                return sign;
            }
        }
        return null;
    }

    public void updateSignData(class_2338 pos, SignDemand demand, class_2487 demandExtra) {
        for (boolean front : Iterate.trueAndFalse) {
            for (SignData sign : (Set)this.sides.get(front)) {
                if (!sign.pos.equals((Object)pos)) continue;
                sign.shouldMigrate = false;
                sign.demand = demand;
                sign.demandExtra = demandExtra;
                return;
            }
        }
    }

    public void iterateQueue(class_1937 level) {
        for (boolean front : Iterate.trueAndFalse) {
            if (((TrackNodeLocation)this.edgeLocation.get((boolean)front)).dimension != level.method_27983()) continue;
            for (SignData sign : new HashSet((Collection)this.sides.get(front))) {
                if (sign.shouldMigrate) {
                    sign.shouldMigrate = false;
                    level.method_35230(sign.pos, (class_2591)TBlockEntities.TRAM_SIGN.get()).ifPresentOrElse(be -> {
                        sign.demand = be.getDemand();
                        sign.demandExtra = be.getDemandExtra();
                        Tramways.LOGGER.info("Successfully migrated tram sign at {}", (Object)sign.pos);
                    }, () -> {
                        Tramways.LOGGER.info("Couldn't migrate tram sign at {}", (Object)sign.pos);
                        this.invalidateAt((class_1936)level, sign.pos);
                        ((Set)this.sides.get(front)).remove(sign);
                    });
                    continue;
                }
                ((Map)this.queue.get(front)).forEach((train, distance) -> sign.demand.execute(sign.demandExtra, (Train)train, (double)distance));
            }
        }
    }

    public SignalBlockEntity.OverlayState getOverlayFor(class_2338 pos) {
        for (boolean front : Iterate.trueAndFalse) {
            Iterator iterator = ((Set)this.sides.get(front)).iterator();
            if (!iterator.hasNext()) continue;
            SignData sign = (SignData)iterator.next();
            if (sign.pos.equals((Object)pos)) {
                return ((Set)this.sides.get(!front)).isEmpty() ? SignalBlockEntity.OverlayState.RENDER : SignalBlockEntity.OverlayState.DUAL;
            }
            return SignalBlockEntity.OverlayState.SKIP;
        }
        return SignalBlockEntity.OverlayState.SKIP;
    }

    public boolean canMerge() {
        return true;
    }

    public void invalidate(class_1936 level) {
        this.sides.forEach(side -> side.forEach(sign -> this.invalidateAt(level, sign.pos)));
    }

    public boolean canCoexistWith(EdgePointType<?> otherType, boolean front) {
        return otherType == this.getType();
    }

    public void blockEntityAdded(class_2586 blockEntity, boolean front) {
        SignData sign = SignData.of(blockEntity);
        if (sign != null) {
            ((Set)this.sides.get(front)).add(sign);
            this.notifyTrains(blockEntity.method_10997());
        }
    }

    public void blockEntityRemoved(class_2338 blockPos, boolean f) {
        this.sides.forEach(side -> side.removeIf(sign -> sign.pos.equals((Object)blockPos)));
        if (this.sides.both(Set::isEmpty)) {
            this.removeFromAllGraphs();
        }
    }

    private void notifyTrains(class_1937 level) {
        TrackGraph graph = Create.RAILWAYS.sided((class_1936)level).getGraph((class_1936)level, (TrackNodeLocation)this.edgeLocation.getFirst());
        if (graph == null) {
            return;
        }
        TrackEdge edge = graph.getConnection(this.edgeLocation.map(arg_0 -> ((TrackGraph)graph).locateNode(arg_0)));
        if (edge == null) {
            return;
        }
        SignalPropagator.notifyTrains((TrackGraph)graph, (TrackEdge[])new TrackEdge[]{edge});
    }

    public void read(class_2487 tag, boolean migration, DimensionPalette dimensions) {
        super.read(tag, migration, dimensions);
        if (migration) {
            return;
        }
        this.sides = Couple.create(HashSet::new);
        for (boolean front : Iterate.trueAndFalse) {
            class_2499 posList = tag.method_10554("Side" + (front ? 1 : 0), 10);
            class_2499 dataList = tag.method_10554("DemandData" + (front ? 1 : 0), 10);
            for (int i = 0; i < posList.size(); ++i) {
                class_2487 posTag = posList.method_10602(i);
                class_2487 dataTag = dataList.method_10602(i);
                SignData sign = new SignData();
                sign.read(posTag, dataTag);
                ((Set)this.sides.get(front)).add(sign);
            }
        }
    }

    public void write(class_2487 tag, DimensionPalette dimensions) {
        super.write(tag, dimensions);
        for (boolean front : Iterate.trueAndFalse) {
            class_2499 posList = new class_2499();
            class_2499 dataList = new class_2499();
            for (SignData sign : (Set)this.sides.get(front)) {
                class_2487 posTag = new class_2487();
                class_2487 dataTag = new class_2487();
                sign.write(posTag, dataTag);
                posList.add((Object)posTag);
                dataList.add((Object)dataTag);
            }
            tag.method_10566("Side" + (front ? 1 : 0), (class_2520)posList);
            tag.method_10566("DemandData" + (front ? 1 : 0), (class_2520)dataList);
        }
    }

    public static class SignData {
        boolean shouldMigrate = false;
        class_2338 pos;
        SignDemand demand;
        class_2487 demandExtra;

        SignData() {
            this(null, null, null);
        }

        SignData(class_2338 pos, SignDemand demand, class_2487 demandExtra) {
            this.pos = pos;
            this.demand = demand;
            this.demandExtra = demandExtra;
        }

        public static SignData of(class_2586 be) {
            SignData signData;
            if (be instanceof TramSignBlockEntity) {
                TramSignBlockEntity sbe = (TramSignBlockEntity)be;
                signData = new SignData(sbe.method_11016(), sbe.getDemand(), sbe.getDemandExtra());
            } else {
                signData = null;
            }
            return signData;
        }

        public void read(class_2487 posTag, class_2487 dataTag) {
            this.pos = class_2512.method_10691((class_2487)posTag);
            if (dataTag.method_33133()) {
                Tramways.LOGGER.info("Going to try migrating tram sign at {}", (Object)this.pos);
                this.shouldMigrate = true;
                return;
            }
            if (dataTag.method_10545("Demand")) {
                this.demand = SignDemand.demands.get(NBTHelper.readResourceLocation((class_2487)dataTag, (String)"Demand"));
            }
            if (dataTag.method_10545("DemandExtra")) {
                this.demandExtra = dataTag.method_10562("DemandExtra");
            }
        }

        public void write(class_2487 posTag, class_2487 dataTag) {
            posTag.method_10543(class_2512.method_10692((class_2338)this.pos));
            if (this.demand != null) {
                NBTHelper.writeResourceLocation((class_2487)dataTag, (String)"Demand", (class_2960)this.demand.id);
            }
            if (this.demandExtra != null) {
                dataTag.method_10566("DemandExtra", (class_2520)this.demandExtra);
            }
        }
    }
}

