/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.content.signs.demands;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import purplecreate.tramways.Tramways;
import purplecreate.tramways.content.signs.TramSignBlock;
import purplecreate.tramways.content.signs.demands.SignDemand;
import purplecreate.tramways.mixinInterfaces.ISpeedLimitableTrain;

public class SpeedSignDemand
extends SignDemand {
    @Override
    @Environment(value=EnvType.CLIENT)
    public class_1799 getIcon() {
        return AllBlocks.SPEEDOMETER.asStack();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void initSettingsGUI(ModularGuiLineBuilder builder) {
        builder.addScrollInput(0, 34, (si, l) -> {
            si.titled(Tramways.translatable("sign_demand.speed", new Object[0])).withRange(1, 101);
            l.withSuffix("%");
        }, "Throttle");
    }

    @Override
    public void setDefaultSettings(class_2487 tag) {
        tag.method_10569("Throttle", 100);
        tag.method_10556("Overridden", false);
    }

    @Override
    public void validateSettings(class_2487 received, class_2487 disk) {
        int nextThrottle = received.method_10550("Throttle");
        if (nextThrottle >= 1 && nextThrottle <= 100) {
            disk.method_10569("Throttle", nextThrottle);
        } else {
            disk.method_10569("Throttle", 100);
        }
    }

    @Override
    public void execute(class_2487 tag, Train train, double distance) {
        ISpeedLimitableTrain speedLimitableTrain;
        float a;
        double s;
        double u;
        double v;
        ISpeedLimitableTrain speedLimitableTrain2;
        double primaryLimit;
        if (SignDemand.isManual(train)) {
            return;
        }
        double nextThrottle = (double)tag.method_10550("Throttle") / 100.0;
        if (train instanceof ISpeedLimitableTrain && nextThrottle > (primaryLimit = (speedLimitableTrain2 = (ISpeedLimitableTrain)train).primaryLimit$get())) {
            nextThrottle = primaryLimit;
        }
        if ((v = nextThrottle * (double)train.maxSpeed()) >= (u = Math.abs(train.speed)) ? distance >= 1.0 : distance > Math.abs(s = (v * v - u * u) / (double)(2.0f * (a = train.acceleration())))) {
            return;
        }
        if (train instanceof ISpeedLimitableTrain && (speedLimitableTrain = (ISpeedLimitableTrain)train).tempSpeedLimit$has()) {
            tag.method_10556("Overridden", true);
            speedLimitableTrain.tempSpeedLimit$updateActual(nextThrottle);
            return;
        }
        tag.method_10556("Overridden", false);
        train.throttle = nextThrottle;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(TramSignBlock.SignType signType, class_2487 tag, class_4587 ms, class_4597 buffer, int light, int overlay) {
        SignDemand.renderTextInCenter("" + tag.method_10550("Throttle"), 0, 0.025f, ms, buffer, light);
        if (tag.method_10577("Overridden")) {
            ms.method_22904(0.0, 0.0, 0.001);
            SignDemand.renderTextInCenter("\u2014", 14427686, 0.0625f, ms, buffer, light);
        }
    }
}

