/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.commands;

import com.cmdpro.databank.megastructures.Megastructure;
import com.cmdpro.databank.megastructures.MegastructureManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

@EventBusSubscriber(modid="databank", bus=EventBusSubscriber.Bus.GAME)
public class DatabankCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"databank").requires(source -> source.hasPermission(4))).then(Commands.literal((String)"spawn_megastructure").then(Commands.argument((String)"megastructure", (ArgumentType)ResourceLocationArgument.id()).suggests((stack, builder) -> SharedSuggestionProvider.suggest(MegastructureManager.megastructures.keySet().stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder)).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(command -> DatabankCommands.spawnMegastructure((CommandContext<CommandSourceStack>)command))))));
    }

    private static int spawnMegastructure(CommandContext<CommandSourceStack> command) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.getLoadedBlockPos(command, (String)"pos");
        ResourceLocation id = (ResourceLocation)command.getArgument("megastructure", ResourceLocation.class);
        Megastructure megastructure = MegastructureManager.megastructures.get(id);
        megastructure.placeIntoWorld((Level)((CommandSourceStack)command.getSource()).getLevel(), pos);
        ((CommandSourceStack)command.getSource()).sendSuccess(() -> Component.translatable((String)"commands.databank.megastructure", (Object[])new Object[]{id.toString(), pos.toShortString()}), true);
        return 1;
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        DatabankCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

