/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.hidden;

import com.cmdpro.databank.Databank;
import com.cmdpro.databank.hidden.Hidden;
import com.cmdpro.databank.hidden.HiddenSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class HiddenManager
extends SimpleJsonResourceReloadListener {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static HiddenManager instance;
    public static Map<ResourceLocation, Hidden> hidden;
    public static HiddenSerializer serializer;

    protected HiddenManager() {
        super(GSON, "databank/hidden");
    }

    public static HiddenManager getOrCreateInstance() {
        if (instance == null) {
            instance = new HiddenManager();
        }
        return instance;
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        hidden = new HashMap<ResourceLocation, Hidden>();
        Databank.LOGGER.info("[DATABANK] Adding Databank Hidden Entries");
        for (Map.Entry<ResourceLocation, JsonElement> i : pObject.entrySet()) {
            ResourceLocation location = i.getKey();
            if (location.getPath().startsWith("_")) continue;
            try {
                JsonObject obj = i.getValue().getAsJsonObject();
                Hidden value = serializer.read(i.getKey(), obj);
                if (value == null) continue;
                value.id = i.getKey();
                hidden.put(i.getKey(), value);
            }
            catch (JsonParseException | IllegalArgumentException e) {
                Databank.LOGGER.error("[DATABANK ERROR] Parsing error loading hidden entry {}", (Object)location, (Object)e);
            }
        }
        Databank.LOGGER.info("[DATABANK] Loaded {} hidden entries", (Object)hidden.size());
    }

    static {
        hidden = new HashMap<ResourceLocation, Hidden>();
        serializer = new HiddenSerializer();
    }
}

