/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.hidden.types;

import com.cmdpro.databank.ClientDatabankUtils;
import com.cmdpro.databank.DatabankRegistries;
import com.cmdpro.databank.hidden.Hidden;
import com.cmdpro.databank.hidden.HiddenCondition;
import com.cmdpro.databank.hidden.HiddenManager;
import com.cmdpro.databank.hidden.HiddenSerializer;
import com.cmdpro.databank.hidden.HiddenTypeInstance;
import com.cmdpro.databank.hidden.conditions.ActualPlayerCondition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;

public class BlockHiddenType
extends HiddenTypeInstance.HiddenType<BlockHiddenTypeInstance> {
    public static final BlockHiddenType INSTANCE = new BlockHiddenType();
    public static final MapCodec<BlockHiddenTypeInstance> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.BLOCK).fieldOf("original").xmap(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).get(arg_0), i -> (ResourceKey)BuiltInRegistries.BLOCK.getResourceKey(i).orElseThrow()).forGetter(type -> type.original), (App)ResourceKey.codec((ResourceKey)Registries.BLOCK).fieldOf("hidden_as").xmap(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).get(arg_0), i -> (ResourceKey)BuiltInRegistries.BLOCK.getResourceKey(i).orElseThrow()).forGetter(type -> type.hiddenAs), (App)ComponentSerialization.CODEC.optionalFieldOf("name_override").forGetter(type -> type.nameOverride), (App)HiddenSerializer.HIDDEN_CONDITION_CODEC.optionalFieldOf("drop_original_loot_condition", (Object)new ActualPlayerCondition()).forGetter(type -> type.dropOriginalLootCondition), (App)Codec.BOOL.optionalFieldOf("should_overwrite_loot_if_hidden", (Object)true).forGetter(type -> type.shouldOverwriteLootIfHidden)).apply((Applicative)instance, BlockHiddenTypeInstance::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BlockHiddenTypeInstance> STREAM_CODEC = StreamCodec.of((buf, val) -> {
        buf.writeResourceKey((ResourceKey)BuiltInRegistries.BLOCK.getResourceKey((Object)val.original).orElseThrow());
        buf.writeResourceKey((ResourceKey)BuiltInRegistries.BLOCK.getResourceKey((Object)val.hiddenAs).orElseThrow());
        buf.writeOptional(val.nameOverride, (buf2, val2) -> ComponentSerialization.STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)buf2), val2));
        buf.writeResourceKey((ResourceKey)DatabankRegistries.HIDDEN_CONDITION_REGISTRY.getResourceKey((Object)val.dropOriginalLootCondition.getSerializer()).orElseThrow());
        val.dropOriginalLootCondition.getSerializer().streamCodec().encode(buf, (Object)val.dropOriginalLootCondition);
        buf.writeBoolean(val.shouldOverwriteLootIfHidden);
    }, buf -> {
        ResourceKey originalKey = buf.readResourceKey(Registries.BLOCK);
        ResourceKey hiddenAsKey = buf.readResourceKey(Registries.BLOCK);
        Block original = (Block)BuiltInRegistries.BLOCK.get(originalKey);
        Block hiddenAs = (Block)BuiltInRegistries.BLOCK.get(hiddenAsKey);
        Optional nameOverride = buf.readOptional(buf2 -> (Component)ComponentSerialization.STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)buf2)));
        ResourceKey dropConditionKey = buf.readResourceKey(DatabankRegistries.HIDDEN_CONDITION_REGISTRY_KEY);
        HiddenCondition.Serializer dropConditionSerializer = (HiddenCondition.Serializer)DatabankRegistries.HIDDEN_CONDITION_REGISTRY.get(dropConditionKey);
        HiddenCondition dropCondition = (HiddenCondition)dropConditionSerializer.streamCodec().decode(buf);
        boolean shouldOverwriteLootIfHidden = buf.readBoolean();
        return new BlockHiddenTypeInstance(original, hiddenAs, nameOverride, dropCondition, shouldOverwriteLootIfHidden);
    });

    @Override
    public MapCodec<BlockHiddenTypeInstance> codec() {
        return CODEC;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, BlockHiddenTypeInstance> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public void updateClient() {
        ClientDatabankUtils.updateWorld();
    }

    public static Block getHiddenBlock(Block block, Player player) {
        for (Hidden i : HiddenManager.hidden.values()) {
            HiddenTypeInstance<?> hiddenTypeInstance = i.type;
            if (!(hiddenTypeInstance instanceof BlockHiddenTypeInstance)) continue;
            BlockHiddenTypeInstance type = (BlockHiddenTypeInstance)hiddenTypeInstance;
            if (type.original == null || type.hiddenAs == null || i.condition == null) continue;
            if (type.isHidden(block, player)) {
                return type.hiddenAs;
            }
            if (!type.matches(block)) continue;
            break;
        }
        return null;
    }

    public static boolean shouldDropOriginalBlock(Block block, Player player) {
        for (Hidden i : HiddenManager.hidden.values()) {
            HiddenTypeInstance<?> hiddenTypeInstance = i.type;
            if (!(hiddenTypeInstance instanceof BlockHiddenTypeInstance)) continue;
            BlockHiddenTypeInstance type = (BlockHiddenTypeInstance)hiddenTypeInstance;
            if (type.original == null || type.hiddenAs == null || i.condition == null) continue;
            if (type.isHidden(block, player) && type.shouldOverwriteLootIfHidden) {
                return false;
            }
            if (!type.matches(block)) continue;
            return type.dropOriginalLootCondition.isUnlocked(player);
        }
        return false;
    }

    public static Block getHiddenBlock(Block block) {
        for (Hidden i : HiddenManager.hidden.values()) {
            HiddenTypeInstance<?> hiddenTypeInstance = i.type;
            if (!(hiddenTypeInstance instanceof BlockHiddenTypeInstance)) continue;
            BlockHiddenTypeInstance type = (BlockHiddenTypeInstance)hiddenTypeInstance;
            if (type.original == null || type.hiddenAs == null || i.condition == null || !type.matches(block)) continue;
            return type.hiddenAs;
        }
        return null;
    }

    public static Optional<Component> getHiddenBlockNameOverride(Block block) {
        for (Hidden i : HiddenManager.hidden.values()) {
            HiddenTypeInstance<?> hiddenTypeInstance = i.type;
            if (!(hiddenTypeInstance instanceof BlockHiddenTypeInstance)) continue;
            BlockHiddenTypeInstance type = (BlockHiddenTypeInstance)hiddenTypeInstance;
            if (type.original == null || !type.matches(block)) continue;
            return type.nameOverride;
        }
        return Optional.empty();
    }

    public static Block getHiddenBlockClient(Block block) {
        for (Map.Entry<ResourceLocation, Hidden> i : HiddenManager.hidden.entrySet()) {
            HiddenTypeInstance<?> hiddenTypeInstance = i.getValue().type;
            if (!(hiddenTypeInstance instanceof BlockHiddenTypeInstance)) continue;
            BlockHiddenTypeInstance type = (BlockHiddenTypeInstance)hiddenTypeInstance;
            if (type.original == null || type.hiddenAs == null) continue;
            if (type.isHiddenClient(block)) {
                return type.hiddenAs;
            }
            if (!type.matches(block)) continue;
            break;
        }
        return null;
    }

    public static class BlockHiddenTypeInstance
    extends HiddenTypeInstance<Block> {
        public Block original;
        public Block hiddenAs;
        public Optional<Component> nameOverride;
        public HiddenCondition dropOriginalLootCondition;
        public boolean shouldOverwriteLootIfHidden;

        public BlockHiddenTypeInstance(Block original, Block hiddenAs, Optional<Component> nameOverride, HiddenCondition dropOriginalLootCondition, boolean shouldOverwiteLootIfHidden) {
            this.original = original;
            this.hiddenAs = hiddenAs;
            this.nameOverride = nameOverride;
            this.dropOriginalLootCondition = dropOriginalLootCondition;
            this.shouldOverwriteLootIfHidden = shouldOverwiteLootIfHidden;
        }

        @Override
        public boolean matches(Block obj) {
            return obj.equals(this.original);
        }

        @Override
        public HiddenTypeInstance.HiddenType<? extends HiddenTypeInstance<Block>> getType() {
            return INSTANCE;
        }
    }
}

