/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.hidden.types;

import com.cmdpro.databank.hidden.Hidden;
import com.cmdpro.databank.hidden.HiddenManager;
import com.cmdpro.databank.hidden.HiddenTypeInstance;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class ItemHiddenType
extends HiddenTypeInstance.HiddenType<ItemHiddenTypeInstance> {
    public static final ItemHiddenType INSTANCE = new ItemHiddenType();
    public static final MapCodec<ItemHiddenTypeInstance> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.ITEM).fieldOf("original").xmap(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0), i -> (ResourceKey)BuiltInRegistries.ITEM.getResourceKey(i).orElseThrow()).forGetter(type -> type.original), (App)ResourceKey.codec((ResourceKey)Registries.ITEM).fieldOf("hidden_as").xmap(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0), i -> (ResourceKey)BuiltInRegistries.ITEM.getResourceKey(i).orElseThrow()).forGetter(type -> type.hiddenAs), (App)ComponentSerialization.CODEC.optionalFieldOf("name_override").forGetter(type -> type.nameOverride)).apply((Applicative)instance, ItemHiddenTypeInstance::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemHiddenTypeInstance> STREAM_CODEC = StreamCodec.of((buf, val) -> {
        buf.writeResourceKey((ResourceKey)BuiltInRegistries.ITEM.getResourceKey((Object)val.original).orElseThrow());
        buf.writeResourceKey((ResourceKey)BuiltInRegistries.ITEM.getResourceKey((Object)val.hiddenAs).orElseThrow());
        buf.writeOptional(val.nameOverride, (buf2, val2) -> ComponentSerialization.STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)buf2), val2));
    }, buf -> {
        ResourceKey originalKey = buf.readResourceKey(Registries.ITEM);
        ResourceKey hiddenAsKey = buf.readResourceKey(Registries.ITEM);
        Item original = (Item)BuiltInRegistries.ITEM.get(originalKey);
        Item hiddenAs = (Item)BuiltInRegistries.ITEM.get(hiddenAsKey);
        Optional nameOverride = buf.readOptional(buf2 -> (Component)ComponentSerialization.STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)buf2)));
        return new ItemHiddenTypeInstance(original, hiddenAs, nameOverride);
    });

    @Override
    public MapCodec<ItemHiddenTypeInstance> codec() {
        return CODEC;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, ItemHiddenTypeInstance> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public void updateClient() {
    }

    public static Item getHiddenItem(Item item, Player player) {
        for (Hidden i : HiddenManager.hidden.values()) {
            HiddenTypeInstance<?> hiddenTypeInstance = i.type;
            if (!(hiddenTypeInstance instanceof ItemHiddenTypeInstance)) continue;
            ItemHiddenTypeInstance type = (ItemHiddenTypeInstance)hiddenTypeInstance;
            if (type.original == null || type.hiddenAs == null || i.condition == null) continue;
            if (type.isHidden(item, player)) {
                return type.hiddenAs;
            }
            if (!type.matches(item)) continue;
            break;
        }
        return null;
    }

    public static Item getHiddenItem(Item item) {
        for (Hidden i : HiddenManager.hidden.values()) {
            HiddenTypeInstance<?> hiddenTypeInstance = i.type;
            if (!(hiddenTypeInstance instanceof ItemHiddenTypeInstance)) continue;
            ItemHiddenTypeInstance type = (ItemHiddenTypeInstance)hiddenTypeInstance;
            if (type.original == null || type.hiddenAs == null || i.condition == null || !type.matches(item)) continue;
            return type.hiddenAs;
        }
        return null;
    }

    public static Optional<Component> getHiddenItemNameOverride(Item item) {
        for (Hidden i : HiddenManager.hidden.values()) {
            HiddenTypeInstance<?> hiddenTypeInstance = i.type;
            if (!(hiddenTypeInstance instanceof ItemHiddenTypeInstance)) continue;
            ItemHiddenTypeInstance type = (ItemHiddenTypeInstance)hiddenTypeInstance;
            if (type.original == null || !type.matches(item)) continue;
            return type.nameOverride;
        }
        return Optional.empty();
    }

    public static Item getHiddenItemClient(Item item) {
        for (Map.Entry<ResourceLocation, Hidden> i : HiddenManager.hidden.entrySet()) {
            HiddenTypeInstance<?> hiddenTypeInstance = i.getValue().type;
            if (!(hiddenTypeInstance instanceof ItemHiddenTypeInstance)) continue;
            ItemHiddenTypeInstance type = (ItemHiddenTypeInstance)hiddenTypeInstance;
            if (type.original == null || type.hiddenAs == null) continue;
            if (type.isHiddenClient(item)) {
                return type.hiddenAs;
            }
            if (!type.matches(item)) continue;
            break;
        }
        return null;
    }

    public static class ItemHiddenTypeInstance
    extends HiddenTypeInstance<Item> {
        public Item original;
        public Item hiddenAs;
        public Optional<Component> nameOverride;

        public ItemHiddenTypeInstance(Item original, Item hiddenAs, Optional<Component> nameOverride) {
            this.original = original;
            this.hiddenAs = hiddenAs;
            this.nameOverride = nameOverride;
        }

        @Override
        public boolean matches(Item obj) {
            return obj.equals(this.original);
        }

        @Override
        public HiddenTypeInstance.HiddenType<? extends HiddenTypeInstance<Item>> getType() {
            return INSTANCE;
        }
    }
}

