/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.megastructures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.WithConditions;

public class Megastructure {
    public static final MapCodec<Megastructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MegastructureBlock.CODEC.codec().listOf().fieldOf("key").forGetter(megastructure -> megastructure.key), (App)Vec3i.CODEC.fieldOf("center").forGetter(megastructure -> megastructure.center), (App)Codec.INT.listOf().listOf().listOf().fieldOf("shape").forGetter(megastructure -> megastructure.shape)).apply((Applicative)instance, Megastructure::new));
    public static final Codec<Optional<WithConditions<Megastructure>>> CONDITION_CODEC = ConditionalOps.createConditionalCodecWithConditions((Codec)CODEC.codec());
    public List<MegastructureBlock> key;
    public Vec3i center;
    public List<List<List<Integer>>> shape;

    public Megastructure(List<MegastructureBlock> key, Vec3i center, List<List<List<Integer>>> shape) {
        this.key = key;
        this.center = center;
        this.shape = shape;
    }

    public static Megastructure createFromWorld(Level level, BlockPos corner1, BlockPos corner2, BlockPos center) {
        BlockPos min = new BlockPos(Math.min(corner1.getX(), corner2.getX()), Math.min(corner1.getY(), corner2.getY()), Math.min(corner1.getZ(), corner2.getZ()));
        BlockPos max = new BlockPos(Math.max(corner1.getX(), corner2.getX()), Math.max(corner1.getY(), corner2.getY()), Math.max(corner1.getZ(), corner2.getZ()));
        BlockPos size = max.subtract((Vec3i)min);
        ArrayList<List<List<Integer>>> shape = new ArrayList<List<List<Integer>>>();
        for (int x = 0; x <= size.getX(); ++x) {
            ArrayList yBlocks = new ArrayList();
            for (int y = 0; y <= size.getY(); ++y) {
                ArrayList<Integer> zBlocks = new ArrayList<Integer>();
                for (int z = 0; z <= size.getZ(); ++z) {
                    zBlocks.add(0);
                }
                yBlocks.add(zBlocks);
            }
            shape.add(yBlocks);
        }
        ArrayList<MegastructureBlock> key = new ArrayList<MegastructureBlock>();
        key.add(new MegastructureBlock(Blocks.AIR.defaultBlockState(), Optional.empty()));
        for (BlockPos i : BlockPos.betweenClosed((BlockPos)corner1, (BlockPos)corner2)) {
            BlockPos blockPos = i.subtract((Vec3i)corner1);
            BlockState blockState = level.getBlockState(i);
            Optional<CompoundTag> nbt = Optional.empty();
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof BlockEntity) {
                BlockEntity ent = blockEntity;
                nbt = Optional.of(ent.saveCustomOnly((HolderLookup.Provider)level.registryAccess()));
            }
            MegastructureBlock block = new MegastructureBlock(blockState, nbt);
            int keyIndex = key.size();
            if (!key.contains(block)) {
                key.add(block);
            } else {
                keyIndex = key.indexOf(block);
            }
            ((List)((List)shape.get(blockPos.getX())).get(blockPos.getY())).set(blockPos.getZ(), keyIndex);
        }
        BlockPos relativeCenter = center.subtract((Vec3i)min);
        return new Megastructure(key, (Vec3i)relativeCenter, shape);
    }

    public void placeIntoWorld(Level level, BlockPos pos) {
        BlockPos startPos;
        BlockPos blockPos = startPos = pos.offset(this.center.multiply(-1));
        for (List<List<Integer>> x : this.shape) {
            for (List<Integer> y : x) {
                for (Integer z : y) {
                    MegastructureBlock block = this.key.get(z);
                    if (!block.state.is(Blocks.STRUCTURE_VOID)) {
                        BlockEntity blockEntity;
                        level.setBlockAndUpdate(blockPos, block.state);
                        if (block.nbt.isPresent() && (blockEntity = level.getBlockEntity(blockPos)) instanceof BlockEntity) {
                            BlockEntity ent = blockEntity;
                            ent.loadCustomOnly(block.nbt.get(), (HolderLookup.Provider)level.registryAccess());
                        }
                    }
                    blockPos = blockPos.offset(0, 0, 1);
                }
                blockPos = new BlockPos(blockPos.getX(), blockPos.getY(), startPos.getZ());
                blockPos = blockPos.offset(0, 1, 0);
            }
            blockPos = new BlockPos(blockPos.getX(), startPos.getY(), blockPos.getZ());
            blockPos = blockPos.offset(1, 0, 0);
        }
    }

    public static class MegastructureBlock {
        public static final MapCodec<MegastructureBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockState.CODEC.fieldOf("state").forGetter(block -> block.state), (App)CompoundTag.CODEC.optionalFieldOf("nbt").forGetter(block -> block.nbt)).apply((Applicative)instance, MegastructureBlock::new));
        public BlockState state;
        public Optional<CompoundTag> nbt;

        public MegastructureBlock(BlockState state, Optional<CompoundTag> nbt) {
            this.state = state;
            this.nbt = nbt;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MegastructureBlock)) {
                return false;
            }
            MegastructureBlock that = (MegastructureBlock)o;
            return Objects.equals(this.state, that.state) && Objects.equals(this.nbt, that.nbt);
        }

        public int hashCode() {
            return Objects.hash(this.state, this.nbt);
        }
    }
}

