/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.megastructures;

import com.cmdpro.databank.Databank;
import com.cmdpro.databank.megastructures.Megastructure;
import com.cmdpro.databank.music.MusicSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.common.conditions.ICondition;

public class MegastructureManager
extends SimpleJsonResourceReloadListener {
    public static HashMap<ResourceLocation, Megastructure> megastructures = new HashMap();
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static MegastructureManager instance;
    public static MusicSerializer serializer;

    protected MegastructureManager() {
        super(GSON, "databank/megastructures");
    }

    public static MegastructureManager getOrCreateInstance() {
        if (instance == null) {
            instance = new MegastructureManager();
        }
        return instance;
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        megastructures = new HashMap();
        Databank.LOGGER.info("[DATABANK] Adding Databank Megastructures");
        for (Map.Entry<ResourceLocation, JsonElement> i : pObject.entrySet()) {
            ResourceLocation location = i.getKey();
            if (location.getPath().startsWith("_")) continue;
            try {
                JsonObject obj = i.getValue().getAsJsonObject();
                Megastructure megastructure = ICondition.getWithWithConditionsCodec(Megastructure.CONDITION_CODEC, (DynamicOps)JsonOps.INSTANCE, (Object)obj).orElse(null);
                megastructures.put(i.getKey(), megastructure);
            }
            catch (JsonParseException | IllegalArgumentException e) {
                Databank.LOGGER.error("[DATABANK ERROR] Parsing error loading music controller type {}", (Object)location, (Object)e);
            }
        }
        Databank.LOGGER.info("[DATABANK] Loaded {} Music Controllers", (Object)megastructures.size());
    }

    static {
        serializer = new MusicSerializer();
    }
}

