/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.megastructures.block.renderers;

import com.cmdpro.databank.megastructures.block.MegastructureSaveBlockEntity;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class MegastructureSaveRenderer
implements BlockEntityRenderer<MegastructureSaveBlockEntity> {
    EntityRenderDispatcher renderDispatcher;

    public MegastructureSaveRenderer(BlockEntityRendererProvider.Context rendererProvider) {
        this.renderDispatcher = rendererProvider.getEntityRenderer();
    }

    public void render(MegastructureSaveBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockPos corner1 = blockEntity.corner1;
        BlockPos corner2 = blockEntity.corner2;
        BlockPos center = blockEntity.center;
        Color color = Color.GREEN;
        Color centerColor = Color.WHITE;
        boolean complete = true;
        if (corner1 == null) {
            corner1 = blockEntity.getBlockPos();
            color = Color.RED;
            complete = false;
        }
        if (corner2 == null) {
            corner2 = corner1;
            color = Color.YELLOW;
            complete = false;
        }
        BlockPos minBlock = new BlockPos(Math.min(corner1.getX(), corner2.getX()), Math.min(corner1.getY(), corner2.getY()), Math.min(corner1.getZ(), corner2.getZ()));
        BlockPos maxBlock = new BlockPos(Math.max(corner1.getX(), corner2.getX()), Math.max(corner1.getY(), corner2.getY()), Math.max(corner1.getZ(), corner2.getZ()));
        Vec3 renderOffset = blockEntity.getBlockPos().getCenter().subtract(0.5, 0.5, 0.5).scale(-1.0);
        Vec3 min = minBlock.getCenter().add(-0.5, -0.5, -0.5).add(renderOffset);
        Vec3 max = maxBlock.getCenter().add(0.5, 0.5, 0.5).add(renderOffset);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        VertexConsumer vertexconsumer = bufferSource.getBuffer(RenderType.lines());
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)vertexconsumer, (double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z, (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f, (float)((float)color.getRed() / 255.0f / 2.0f), (float)((float)color.getGreen() / 255.0f / 2.0f), (float)((float)color.getBlue() / 255.0f / 2.0f));
        if (complete && center != null) {
            Vec3 centerMin = center.getCenter().add(-0.5, -0.5, -0.5).add(renderOffset);
            Vec3 centerMax = center.getCenter().add(0.5, 0.5, 0.5).add(renderOffset);
            LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)vertexconsumer, (double)centerMin.x, (double)centerMin.y, (double)centerMin.z, (double)centerMax.x, (double)centerMax.y, (double)centerMax.z, (float)((float)centerColor.getRed() / 255.0f), (float)((float)centerColor.getGreen() / 255.0f), (float)((float)centerColor.getBlue() / 255.0f), (float)1.0f, (float)((float)centerColor.getRed() / 255.0f / 2.0f), (float)((float)centerColor.getGreen() / 255.0f / 2.0f), (float)((float)centerColor.getBlue() / 255.0f / 2.0f));
        }
        if (bufferSource instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource source = (MultiBufferSource.BufferSource)bufferSource;
            source.endBatch(RenderType.lines());
        }
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        if (complete) {
            this.renderInvisibleBlocks(blockEntity, bufferSource, poseStack);
        }
    }

    private void renderInvisibleBlocks(MegastructureSaveBlockEntity blockEntity, MultiBufferSource bufferSource, PoseStack poseStack) {
        Level blockgetter = blockEntity.getLevel();
        VertexConsumer vertexconsumer = bufferSource.getBuffer(RenderType.lines());
        BlockPos blockpos = blockEntity.getBlockPos();
        BlockPos corner1 = blockEntity.corner1;
        BlockPos corner2 = blockEntity.corner2;
        for (BlockPos i : BlockPos.betweenClosed((BlockPos)corner1, (BlockPos)corner2)) {
            BlockState blockstate = blockgetter.getBlockState(i);
            boolean structureVoid = blockstate.is(Blocks.STRUCTURE_VOID);
            boolean barrier = blockstate.is(Blocks.BARRIER);
            boolean light = blockstate.is(Blocks.LIGHT);
            if (!structureVoid && !barrier && !light) continue;
            double d0 = (float)(i.getX() - blockpos.getX()) + 0.45f;
            double d1 = (float)(i.getY() - blockpos.getY()) + 0.45f;
            double d2 = (float)(i.getZ() - blockpos.getZ()) + 0.45f;
            double d3 = (float)(i.getX() - blockpos.getX()) + 0.55f;
            double d4 = (float)(i.getY() - blockpos.getY()) + 0.55f;
            double d5 = (float)(i.getZ() - blockpos.getZ()) + 0.55f;
            if (structureVoid) {
                LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)vertexconsumer, (double)d0, (double)d1, (double)d2, (double)d3, (double)d4, (double)d5, (float)1.0f, (float)0.75f, (float)0.75f, (float)1.0f, (float)1.0f, (float)0.75f, (float)0.75f);
                continue;
            }
            if (barrier) {
                LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)vertexconsumer, (double)d0, (double)d1, (double)d2, (double)d3, (double)d4, (double)d5, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                continue;
            }
            if (!light) continue;
            LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)vertexconsumer, (double)d0, (double)d1, (double)d2, (double)d3, (double)d4, (double)d5, (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
        }
    }
}

