/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.mixin;

import com.cmdpro.databank.DatabankUtils;
import com.cmdpro.databank.hidden.types.BlockHiddenType;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.class})
public abstract class BlockBehaviourMixin {
    @Shadow
    protected abstract Block asBlock();

    @Inject(method={"getDrops"}, at={@At(value="HEAD")}, cancellable=true)
    public void getDrops(BlockState pState, LootParams.Builder pParams, CallbackInfoReturnable<List<ItemStack>> cir) {
        Object object = pParams.getOptionalParameter(LootContextParams.THIS_ENTITY);
        if (object instanceof Player) {
            Player player = (Player)object;
            block = BlockHiddenType.getHiddenBlock(this.asBlock(), player);
            if (block != null && !BlockHiddenType.shouldDropOriginalBlock(this.asBlock(), player)) {
                cir.setReturnValue((Object)DatabankUtils.changeBlockType(pState, block).getDrops(pParams));
            }
        } else {
            block = BlockHiddenType.getHiddenBlock(this.asBlock());
            if (block != null && !BlockHiddenType.shouldDropOriginalBlock(this.asBlock(), null)) {
                cir.setReturnValue((Object)DatabankUtils.changeBlockType(pState, block).getDrops(pParams));
            }
        }
    }
}

