/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.model;

import com.cmdpro.databank.DatabankExtraCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2i;
import org.joml.Vector3f;

public class DatabankPartDefinition {
    public static final Codec<DatabankPartDefinition> CODEC = Codec.recursive((String)DatabankPartDefinition.class.getSimpleName(), recursedCodec -> RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(part -> part.name), (App)ExtraCodecs.VECTOR3F.fieldOf("rotation").forGetter(part -> part.rotation), (App)ExtraCodecs.VECTOR3F.fieldOf("offset").forGetter(part -> part.offset), (App)recursedCodec.listOf().optionalFieldOf("children", new ArrayList()).forGetter(part -> part.children), (App)Codec.BOOL.optionalFieldOf("isCube", (Object)false).forGetter(part -> part.isCube), (App)Codec.BOOL.optionalFieldOf("isMesh", (Object)false).forGetter(part -> part.isMesh), (App)Codec.BOOL.optionalFieldOf("mirror", (Object)false).forGetter(part -> part.mirror), (App)DatabankExtraCodecs.VECTOR2I.optionalFieldOf("texOffset", (Object)new Vector2i()).forGetter(part -> part.texOffset), (App)ExtraCodecs.VECTOR3F.optionalFieldOf("origin", (Object)new Vector3f()).forGetter(part -> part.origin), (App)ExtraCodecs.VECTOR3F.optionalFieldOf("dimensions", (Object)new Vector3f(1.0f, 1.0f, 1.0f)).forGetter(part -> part.dimensions), (App)Codec.FLOAT.optionalFieldOf("inflate", (Object)Float.valueOf(0.0f)).forGetter(part -> Float.valueOf(part.inflate)), (App)Vertex.CODEC.listOf().listOf().optionalFieldOf("faces").forGetter(part -> part.faces)).apply((Applicative)instance, DatabankPartDefinition::new)));
    public String name;
    public Vector3f rotation;
    public Vector3f offset;
    public List<DatabankPartDefinition> children;
    public boolean isCube;
    public boolean isMesh;
    public boolean mirror;
    public Vector2i texOffset;
    public Vector3f origin;
    public Vector3f dimensions;
    public float inflate;
    public Optional<List<List<Vertex>>> faces;

    public DatabankPartDefinition(String name, Vector3f rotation, Vector3f offset, List<DatabankPartDefinition> children) {
        this(name, rotation, offset, children, false, false, false, null, null, null, 0.0f, Optional.empty());
    }

    public DatabankPartDefinition(String name, Vector3f rotation, Vector3f offset, List<DatabankPartDefinition> children, boolean mirror, Vector2i texOffset, Vector3f origin, Vector3f dimensions, float inflate) {
        this(name, rotation, offset, children, true, false, mirror, texOffset, origin, dimensions, inflate, Optional.empty());
    }

    public DatabankPartDefinition(String name, Vector3f rotation, Vector3f offset, List<DatabankPartDefinition> children, boolean isCube, boolean isMesh, boolean mirror, Vector2i texOffset, Vector3f origin, Vector3f dimensions, float inflate, Optional<List<List<Vertex>>> faces) {
        this.name = name;
        this.rotation = rotation;
        this.offset = offset;
        this.children = children;
        this.isCube = isCube;
        this.isMesh = isMesh;
        this.mirror = mirror;
        this.texOffset = texOffset;
        this.origin = origin;
        this.dimensions = dimensions;
        this.inflate = inflate;
        this.faces = faces;
    }

    public CubeListBuilder createCubeListBuilder() {
        if (!this.isCube) {
            return CubeListBuilder.create();
        }
        return CubeListBuilder.create().texOffs(this.texOffset.x, this.texOffset.y).mirror(this.mirror).addBox(this.origin.x, this.origin.y, this.origin.z, this.dimensions.x, this.dimensions.y, this.dimensions.z, new CubeDeformation(this.inflate));
    }

    public PartPose createPartPose() {
        return PartPose.offsetAndRotation((float)this.offset.x, (float)this.offset.y, (float)this.offset.z, (float)this.rotation.x, (float)this.rotation.y, (float)this.rotation.z);
    }

    public static class Vertex {
        public static final Codec<Vertex> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("x").forGetter(vertice -> vertice.pos.x), (App)Codec.DOUBLE.fieldOf("y").forGetter(vertice -> vertice.pos.y), (App)Codec.DOUBLE.fieldOf("z").forGetter(vertice -> vertice.pos.z), (App)Codec.DOUBLE.fieldOf("u").forGetter(vertice -> vertice.u), (App)Codec.DOUBLE.fieldOf("v").forGetter(vertice -> vertice.v)).apply((Applicative)instance, (x, y, z, u, v) -> new Vertex(new Vec3(x.doubleValue(), y.doubleValue(), z.doubleValue()), (double)u, (double)v)));
        public Vec3 pos;
        public double u;
        public double v;

        public Vertex(Vec3 pos, double u, double v) {
            this.pos = pos;
            this.u = u;
            this.v = v;
        }
    }

    public static class Face {
        public List<Vertex> vertices;
        public Vec3 normal;

        public Face(List<Vertex> vertices, Vec3 normal) {
            this.vertices = vertices;
            this.normal = normal;
        }
    }
}

