/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.model;

import com.cmdpro.databank.model.DatabankModel;
import com.cmdpro.databank.model.DatabankPartDefinition;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ModelPose {
    public List<ModelPosePart> parts;
    public final HashMap<String, ModelPosePart> stringToPart;

    public ModelPose(List<ModelPosePart> parts, HashMap<String, ModelPosePart> stringToPart) {
        this.parts = parts;
        this.stringToPart = stringToPart;
    }

    public static class ModelPosePart {
        public DatabankPartDefinition part;
        public List<ModelPosePart> children;
        public Vector3f pos;
        public Vector3f rotation;
        public Vector3f scale;

        public ModelPosePart(DatabankPartDefinition part, List<ModelPosePart> children, Vector3f pos, Vector3f rotation, Vector3f scale) {
            this.part = part;
            this.children = children;
            this.pos = pos;
            this.rotation = rotation;
            this.scale = scale;
        }

        public void offsetPosition(Vector3f offset) {
            this.pos.add(offset.x, offset.y, offset.z);
        }

        public void offsetRotation(Vector3f offset) {
            this.rotation.add((Vector3fc)offset);
        }

        public void offsetScale(Vector3f offset) {
            this.scale.add((Vector3fc)offset);
        }

        public void render(DatabankModel model, float partialTick, PoseStack pPoseStack, VertexConsumer pConsumer, int pPackedLight, int pPackedOverlay, int pColor, Vec3 normalMult) {
            pPoseStack.pushPose();
            ArrayList<DatabankPartDefinition.Face> faces = null;
            if (this.part.isCube) {
                pPoseStack.pushPose();
                Vec3 origin = new Vec3((double)this.part.origin.x, (double)this.part.origin.y, (double)this.part.origin.z);
                Vec3 x0y0z0 = new Vec3(0.0, 0.0, 0.0).add((double)(-this.part.inflate), (double)this.part.inflate, (double)(-this.part.inflate)).add(origin);
                Iterator<DatabankPartDefinition.Vertex> x1y0z0 = new Vec3((double)this.part.dimensions.x, 0.0, 0.0).add((double)this.part.inflate, (double)this.part.inflate, (double)(-this.part.inflate)).add(origin);
                Vec3 x1y1z0 = new Vec3((double)this.part.dimensions.x, (double)this.part.dimensions.y, 0.0).add((double)this.part.inflate, (double)(-this.part.inflate), (double)(-this.part.inflate)).add(origin);
                Vec3 x0y1z0 = new Vec3(0.0, (double)this.part.dimensions.y, 0.0).add((double)(-this.part.inflate), (double)(-this.part.inflate), (double)(-this.part.inflate)).add(origin);
                Vec3 x0y0z1 = new Vec3(0.0, 0.0, (double)this.part.dimensions.z).add((double)(-this.part.inflate), (double)this.part.inflate, (double)this.part.inflate).add(origin);
                Vec3 x1y0z1 = new Vec3((double)this.part.dimensions.x, 0.0, (double)this.part.dimensions.z).add((double)this.part.inflate, (double)this.part.inflate, (double)this.part.inflate).add(origin);
                Vec3 x1y1z1 = new Vec3((double)this.part.dimensions.x, (double)this.part.dimensions.y, (double)this.part.dimensions.z).add((double)this.part.inflate, (double)(-this.part.inflate), (double)this.part.inflate).add(origin);
                Vec3 x0y1z1 = new Vec3(0.0, (double)this.part.dimensions.y, (double)this.part.dimensions.z).add((double)(-this.part.inflate), (double)(-this.part.inflate), (double)this.part.inflate).add(origin);
                float uMin = (float)this.part.texOffset.x + this.part.dimensions.z + this.part.dimensions.x;
                float vMin = this.part.texOffset.y;
                float uMax = (float)this.part.texOffset.x + this.part.dimensions.z + this.part.dimensions.x + this.part.dimensions.x;
                float vMax = (float)this.part.texOffset.y + this.part.dimensions.z;
                ArrayList<DatabankPartDefinition.Vertex> down = new ArrayList<DatabankPartDefinition.Vertex>();
                down.add(new DatabankPartDefinition.Vertex(x1y1z0, uMax, vMax));
                down.add(new DatabankPartDefinition.Vertex(x0y1z0, uMin, vMax));
                down.add(new DatabankPartDefinition.Vertex(x0y1z1, uMin, vMin));
                down.add(new DatabankPartDefinition.Vertex(x1y1z1, uMax, vMin));
                uMin = (float)this.part.texOffset.x + this.part.dimensions.z;
                vMin = (float)this.part.texOffset.y + this.part.dimensions.z;
                uMax = (float)this.part.texOffset.x + this.part.dimensions.z + this.part.dimensions.x;
                vMax = this.part.texOffset.y;
                ArrayList<DatabankPartDefinition.Vertex> up = new ArrayList<DatabankPartDefinition.Vertex>();
                up.add(new DatabankPartDefinition.Vertex(x1y0z1, uMax, vMax));
                up.add(new DatabankPartDefinition.Vertex(x0y0z1, uMin, vMax));
                up.add(new DatabankPartDefinition.Vertex(x0y0z0, uMin, vMin));
                up.add(new DatabankPartDefinition.Vertex((Vec3)x1y0z0, uMax, vMin));
                uMin = (float)this.part.texOffset.x + this.part.dimensions.z + this.part.dimensions.x;
                vMin = (float)this.part.texOffset.y + this.part.dimensions.z + this.part.dimensions.y;
                uMax = (float)this.part.texOffset.x + this.part.dimensions.z + this.part.dimensions.x + this.part.dimensions.z;
                vMax = (float)this.part.texOffset.y + this.part.dimensions.z;
                ArrayList<DatabankPartDefinition.Vertex> west = new ArrayList<DatabankPartDefinition.Vertex>();
                west.add(new DatabankPartDefinition.Vertex(x1y0z1, uMax, vMax));
                west.add(new DatabankPartDefinition.Vertex((Vec3)x1y0z0, uMin, vMax));
                west.add(new DatabankPartDefinition.Vertex(x1y1z0, uMin, vMin));
                west.add(new DatabankPartDefinition.Vertex(x1y1z1, uMax, vMin));
                uMin = (float)this.part.texOffset.x + this.part.dimensions.z;
                vMin = (float)this.part.texOffset.y + this.part.dimensions.z + this.part.dimensions.y;
                uMax = (float)this.part.texOffset.x + this.part.dimensions.z + this.part.dimensions.x;
                vMax = (float)this.part.texOffset.y + this.part.dimensions.z;
                ArrayList<DatabankPartDefinition.Vertex> north = new ArrayList<DatabankPartDefinition.Vertex>();
                north.add(new DatabankPartDefinition.Vertex((Vec3)x1y0z0, uMax, vMax));
                north.add(new DatabankPartDefinition.Vertex(x0y0z0, uMin, vMax));
                north.add(new DatabankPartDefinition.Vertex(x0y1z0, uMin, vMin));
                north.add(new DatabankPartDefinition.Vertex(x1y1z0, uMax, vMin));
                uMin = this.part.texOffset.x;
                vMin = (float)this.part.texOffset.y + this.part.dimensions.z + this.part.dimensions.y;
                uMax = (float)this.part.texOffset.x + this.part.dimensions.z;
                vMax = (float)this.part.texOffset.y + this.part.dimensions.z;
                ArrayList<DatabankPartDefinition.Vertex> east = new ArrayList<DatabankPartDefinition.Vertex>();
                east.add(new DatabankPartDefinition.Vertex(x0y0z0, uMax, vMax));
                east.add(new DatabankPartDefinition.Vertex(x0y0z1, uMin, vMax));
                east.add(new DatabankPartDefinition.Vertex(x0y1z1, uMin, vMin));
                east.add(new DatabankPartDefinition.Vertex(x0y1z0, uMax, vMin));
                uMin = (float)this.part.texOffset.x + this.part.dimensions.z + this.part.dimensions.x + this.part.dimensions.z;
                vMin = (float)this.part.texOffset.y + this.part.dimensions.z + this.part.dimensions.y;
                uMax = (float)this.part.texOffset.x + this.part.dimensions.z + this.part.dimensions.x + this.part.dimensions.z + this.part.dimensions.x;
                vMax = (float)this.part.texOffset.y + this.part.dimensions.z;
                ArrayList<DatabankPartDefinition.Vertex> south = new ArrayList<DatabankPartDefinition.Vertex>();
                south.add(new DatabankPartDefinition.Vertex(x0y0z1, uMax, vMax));
                south.add(new DatabankPartDefinition.Vertex(x1y0z1, uMin, vMax));
                south.add(new DatabankPartDefinition.Vertex(x1y1z1, uMin, vMin));
                south.add(new DatabankPartDefinition.Vertex(x0y1z1, uMax, vMin));
                boolean[] facesVisible = new boolean[]{true, true, true, true, true, true};
                if ((double)(this.part.dimensions.x + this.part.inflate) <= 0.001 && (double)(this.part.dimensions.x + this.part.inflate) >= -0.001) {
                    facesVisible[2] = false;
                }
                if ((double)(this.part.dimensions.y + this.part.inflate) <= 0.001 && (double)(this.part.dimensions.y + this.part.inflate) >= -0.001) {
                    facesVisible[0] = false;
                }
                if ((double)(this.part.dimensions.z + this.part.inflate) <= 0.001 && (double)(this.part.dimensions.z + this.part.inflate) >= -0.001) {
                    facesVisible[5] = false;
                }
                faces = new ArrayList();
                if (facesVisible[0]) {
                    faces.add(new DatabankPartDefinition.Face(down, new Vec3(0.0, -1.0 * normalMult.y, 0.0)));
                }
                if (facesVisible[1]) {
                    faces.add(new DatabankPartDefinition.Face(up, new Vec3(0.0, 1.0 * normalMult.y, 0.0)));
                }
                if (facesVisible[2]) {
                    faces.add(new DatabankPartDefinition.Face(west, new Vec3(-1.0 * normalMult.x, 0.0, 0.0)));
                }
                if (facesVisible[3]) {
                    faces.add(new DatabankPartDefinition.Face(north, new Vec3(0.0, 0.0, -1.0 * normalMult.z)));
                }
                if (facesVisible[4]) {
                    faces.add(new DatabankPartDefinition.Face(east, new Vec3(1.0 * normalMult.x, 0.0, 0.0)));
                }
                if (facesVisible[5]) {
                    faces.add(new DatabankPartDefinition.Face(south, new Vec3(0.0, 0.0, 1.0 * normalMult.z)));
                }
                Matrix4f matrix4f = new Matrix4f();
                matrix4f.rotateZYX(this.part.rotation.z, this.part.rotation.y, this.part.rotation.x);
                for (DatabankPartDefinition.Face i : faces) {
                    for (DatabankPartDefinition.Vertex j : i.vertices) {
                        Vector3f pos = j.pos.toVector3f();
                        matrix4f.transformPosition(pos);
                        pos.add((Vector3fc)new Vector3f(this.pos.x, this.pos.y, this.pos.z));
                        j.pos = new Vec3((double)pos.x, (double)(-pos.y), (double)pos.z);
                    }
                }
                pPoseStack.popPose();
            }
            if (this.part.isMesh) {
                pPoseStack.translate(this.pos.x / 16.0f, this.pos.y / 16.0f, this.pos.z / 16.0f);
                pPoseStack.mulPose(new Quaternionf().rotationZYX(this.rotation.z, this.rotation.y, this.rotation.x));
                List faces2 = this.part.faces.orElse(null);
                if (faces2 != null) {
                    faces = new ArrayList<DatabankPartDefinition.Face>();
                    Vector3f middle = ((DatabankPartDefinition.Vertex)((List)faces2.getFirst()).getFirst()).pos.toVector3f();
                    for (List i : faces2) {
                        if (i.size() != 3 && i.size() != 4) continue;
                        for (Object j : i) {
                            middle.lerp((Vector3fc)((DatabankPartDefinition.Vertex)j).pos.toVector3f(), 0.5f);
                        }
                        Vector3f faceMiddle = ((DatabankPartDefinition.Vertex)i.getFirst()).pos.toVector3f();
                        for (DatabankPartDefinition.Vertex j : i) {
                            faceMiddle.lerp((Vector3fc)j.pos.toVector3f(), 0.5f);
                        }
                        faceMiddle.mul(1.0f, -1.0f, 1.0f);
                        middle.mul(1.0f, -1.0f, 1.0f);
                        pPoseStack.last().pose().transformPosition(middle);
                        pPoseStack.last().pose().transformPosition(faceMiddle);
                        Vector3f normal = new Vector3f((Vector3fc)faceMiddle).sub((Vector3fc)middle).normalize();
                        faces.add(new DatabankPartDefinition.Face(i, new Vec3((double)normal.x, (double)normal.y, (double)normal.z)));
                    }
                }
            }
            if (faces != null) {
                for (DatabankPartDefinition.Face i : faces) {
                    if (i.vertices.size() != 3 && i.vertices.size() != 4) continue;
                    for (DatabankPartDefinition.Vertex j : i.vertices) {
                        float x = (float)j.pos.x() / 16.0f;
                        float y = (float)(-j.pos.y()) / 16.0f;
                        float z = (float)j.pos.z() / 16.0f;
                        pConsumer.addVertex(pPoseStack.last(), x, y, z);
                        pConsumer.setColor(pColor);
                        pConsumer.setUv((float)j.u / (float)model.textureSize.x, (float)j.v / (float)model.textureSize.y);
                        pConsumer.setOverlay(pPackedOverlay);
                        pConsumer.setLight(pPackedLight);
                        pConsumer.setNormal((float)i.normal.x, (float)i.normal.y, (float)i.normal.z);
                    }
                    if (i.vertices.size() != 3) continue;
                    DatabankPartDefinition.Vertex j = i.vertices.getLast();
                    float x = (float)j.pos.x() / 16.0f;
                    float y = (float)(-j.pos.y()) / 16.0f;
                    float z = (float)j.pos.z() / 16.0f;
                    pConsumer.addVertex(pPoseStack.last(), x, y, z);
                    pConsumer.setColor(pColor);
                    pConsumer.setUv((float)j.u / (float)model.textureSize.x, (float)j.v / (float)model.textureSize.y);
                    pConsumer.setOverlay(pPackedOverlay);
                    pConsumer.setLight(pPackedLight);
                    pConsumer.setNormal((float)i.normal.x, (float)i.normal.y, (float)i.normal.z);
                }
            }
            pPoseStack.popPose();
        }
    }
}

