/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.model.animation;

import com.cmdpro.databank.model.DatabankAnimation;
import com.cmdpro.databank.model.DatabankModel;
import com.cmdpro.databank.model.animation.DatabankAnimationDefinition;
import com.cmdpro.databank.model.animation.DatabankAnimationReference;
import com.mojang.blaze3d.Blaze3D;
import java.util.HashMap;

public class DatabankAnimationState {
    public double startTime;
    public String defaultAnim;
    public double speed;
    private DatabankAnimationDefinition anim;
    private HashMap<String, DatabankAnimationDefinition> animDefinitions = new HashMap();
    private HashMap<String, DatabankAnimationReference> anims = new HashMap();

    public DatabankAnimationState(String defaultAnim) {
        this.defaultAnim = defaultAnim;
    }

    public void updateAnimDefinitions(DatabankModel model) {
        for (DatabankAnimationReference i : this.anims.values()) {
            this.animDefinitions.put(i.id, ((DatabankAnimation)model.animations.getOrDefault(i.id, null)).createAnimationDefinition(i.id));
        }
    }

    public double getProgress() {
        if (this.anim != null && this.anim.animation.looping) {
            return (this.getTime() - this.startTime) % (double)this.anim.animation.length;
        }
        return this.getTime() - this.startTime;
    }

    public void start() {
        this.startTime = this.getTime();
    }

    public void update() {
        if (this.anim == null) {
            this.anim = this.animDefinitions.get(this.defaultAnim);
        }
        if (this.isDone()) {
            this.anims.get((Object)this.anim.id).onEnd.call(this, this.anim);
        }
    }

    public void resetAnim() {
        if (this.anim != null) {
            this.start();
            this.anims.get((Object)this.anim.id).onStart.call(this, this.anim);
        }
    }

    public void setAnim(String anim) {
        if (this.anim == null || !this.anim.id.equals(anim)) {
            this.start();
            this.anim = this.animDefinitions.get(anim);
            this.anims.get((Object)anim).onStart.call(this, this.anim);
        }
    }

    public boolean isDone() {
        if (this.anim == null) {
            return true;
        }
        return (double)this.anim.animation.length <= this.getProgress() && !this.anim.animation.looping;
    }

    public DatabankAnimationDefinition getAnim() {
        return this.anim;
    }

    public boolean isCurrentAnim(String anim) {
        if (this.anim == null) {
            return false;
        }
        return this.anim.id.equals(anim);
    }

    public DatabankAnimationState addAnim(DatabankAnimationReference reference) {
        this.anims.put(reference.id, reference);
        return this;
    }

    public DatabankAnimationState removeAnim(DatabankAnimationDefinition definition) {
        this.anims.remove(definition.id);
        return this;
    }

    private double getTime() {
        return Blaze3D.getTime();
    }
}

