/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.model.entity;

import com.cmdpro.databank.model.entity.DatabankEntityModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public abstract class DatabankEntityRenderer<T extends Entity>
extends EntityRenderer<T> {
    private DatabankEntityModel<T> model;

    public DatabankEntityRenderer(EntityRendererProvider.Context context, DatabankEntityModel<T> model, float shadowRadius) {
        super(context);
        this.shadowRadius = shadowRadius;
        this.model = model;
    }

    public void render(T pEntity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.render(pEntity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        poseStack.pushPose();
        poseStack.translate(0.0, 1.5, 0.0);
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        this.getModel().setupModelPose(pEntity, partialTick);
        this.getModel().render(pEntity, partialTick, poseStack, bufferSource, packedLight, this.getOverlayCoords(pEntity), -1, new Vec3(1.0, 1.0, 1.0));
        poseStack.popPose();
    }

    public int getOverlayCoords(T entity) {
        return OverlayTexture.pack((int)OverlayTexture.u((float)0.0f), (int)OverlayTexture.v((boolean)false));
    }

    public DatabankEntityModel<T> getModel() {
        return this.model;
    }
}

