/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.multiblock;

import com.cmdpro.databank.multiblock.MultiblockPredicate;
import com.cmdpro.databank.multiblock.MultiblockRenderer;
import com.cmdpro.databank.multiblock.predicates.AnyMultiblockPredicate;
import com.cmdpro.databank.multiblock.predicates.BlockstateMultiblockPredicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class Multiblock
implements BlockAndTintGetter {
    public String[][] multiblockLayers;
    public Map<Character, MultiblockPredicate> key;
    public BlockPos center;
    private List<List<List<PredicateAndPos>>> states;
    private List<PredicateAndPos> statesForMultiblockChecks;

    public Multiblock(String[][] multiblockLayers, Map<Character, MultiblockPredicate> key, BlockPos center) {
        this.multiblockLayers = multiblockLayers;
        key.put(Character.valueOf(' '), new BlockstateMultiblockPredicate(Blocks.AIR.defaultBlockState()));
        key.put(Character.valueOf('*'), new AnyMultiblockPredicate());
        this.key = key;
        this.center = center;
    }

    public List<List<List<PredicateAndPos>>> getStates() {
        return this.getStates(false);
    }

    public List<List<List<PredicateAndPos>>> getStates(boolean forceCacheReset) {
        if (forceCacheReset || this.states == null) {
            int x = 0;
            int y = 0;
            int z = 0;
            ArrayList<List<List<PredicateAndPos>>> states = new ArrayList<List<List<PredicateAndPos>>>();
            for (String[] i : this.multiblockLayers) {
                z = 0;
                ArrayList states2 = new ArrayList();
                for (String o : i) {
                    ArrayList<PredicateAndPos> layer = new ArrayList<PredicateAndPos>();
                    x = 0;
                    for (char p : o.toCharArray()) {
                        layer.add(new PredicateAndPos(this.key.get(Character.valueOf(p)), new BlockPos(x, y, z).offset(this.center.getX(), this.center.getY(), this.center.getZ())));
                        ++x;
                    }
                    states2.add(layer);
                    ++z;
                }
                states.add(states2);
                ++y;
            }
            this.states = states;
            return states;
        }
        return this.states;
    }

    private List<PredicateAndPos> getStatesForMultiblockCheck() {
        return this.getStatesForMultiblockCheck(false);
    }

    private List<PredicateAndPos> getStatesForMultiblockCheck(boolean forceCacheReset) {
        if (forceCacheReset || this.statesForMultiblockChecks == null) {
            List<List<List<PredicateAndPos>>> states = this.getStates();
            ArrayList<PredicateAndPos> statesForMultiChecks = new ArrayList<PredicateAndPos>();
            for (List<List<PredicateAndPos>> i : states) {
                for (List<PredicateAndPos> j : i) {
                    for (PredicateAndPos k : j) {
                        if (k.predicate instanceof AnyMultiblockPredicate) continue;
                        statesForMultiChecks.add(k);
                    }
                }
            }
            this.statesForMultiblockChecks = statesForMultiChecks;
            return statesForMultiChecks;
        }
        return this.statesForMultiblockChecks;
    }

    public Rotation getMultiblockRotation(Level level, BlockPos pos) {
        if (this.checkMultiblock(level, pos, Rotation.NONE)) {
            return Rotation.NONE;
        }
        if (this.checkMultiblock(level, pos, Rotation.COUNTERCLOCKWISE_90)) {
            return Rotation.COUNTERCLOCKWISE_90;
        }
        if (this.checkMultiblock(level, pos, Rotation.CLOCKWISE_180)) {
            return Rotation.CLOCKWISE_180;
        }
        if (this.checkMultiblock(level, pos, Rotation.CLOCKWISE_90)) {
            return Rotation.CLOCKWISE_90;
        }
        return null;
    }

    public boolean checkMultiblock(Level level, BlockPos pos) {
        return this.checkMultiblock(level, pos, Rotation.NONE);
    }

    public boolean checkMultiblockAll(Level level, BlockPos pos) {
        return this.checkMultiblock(level, pos, Rotation.NONE) || this.checkMultiblock(level, pos, Rotation.CLOCKWISE_90) || this.checkMultiblock(level, pos, Rotation.CLOCKWISE_180) || this.checkMultiblock(level, pos, Rotation.COUNTERCLOCKWISE_90);
    }

    public boolean checkMultiblock(Level level, BlockPos pos, Rotation rotation) {
        for (PredicateAndPos i : this.getStatesForMultiblockCheck()) {
            BlockPos blockPos;
            BlockState state;
            if (i.predicate == null || i.predicate.isSame(state = level.getBlockState(blockPos = i.offset.rotate(rotation).offset(pos.getX(), pos.getY(), pos.getZ())), rotation)) continue;
            return false;
        }
        return true;
    }

    public List<List<String>> getMultiblockLayersList() {
        return Arrays.stream(this.multiblockLayers).map(a -> Arrays.stream(a).toList()).toList();
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos pos) {
        BlockState state = this.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof EntityBlock) {
            EntityBlock eb = (EntityBlock)block;
            return MultiblockRenderer.blockEntityCache.computeIfAbsent(pos.immutable(), p -> eb.newBlockEntity(p, state));
        }
        return null;
    }

    public BlockState getBlockState(BlockPos pos) {
        if (pos.getY() >= 0 && pos.getY() < this.states.size() && pos.getZ() >= 0 && pos.getZ() < this.states.get(pos.getY()).size() && pos.getX() >= 0 && pos.getX() < this.states.get(pos.getY()).get(pos.getZ()).size()) {
            return this.states.get((int)pos.getY()).get((int)pos.getZ()).get((int)pos.getX()).predicate.getVisual();
        }
        return Blocks.AIR.defaultBlockState();
    }

    public FluidState getFluidState(BlockPos pos) {
        return Fluids.EMPTY.defaultFluidState();
    }

    public float getShade(Direction direction, boolean shaded) {
        return 1.0f;
    }

    public LevelLightEngine getLightEngine() {
        return null;
    }

    public int getBlockTint(BlockPos pos, ColorResolver color) {
        Biome plains = (Biome)Minecraft.getInstance().level.registryAccess().registryOrThrow(Registries.BIOME).getOrThrow(Biomes.PLAINS);
        return color.getColor(plains, (double)pos.getX(), (double)pos.getZ());
    }

    public int getBrightness(LightLayer type, BlockPos pos) {
        return 15;
    }

    public int getRawBrightness(BlockPos pos, int ambientDarkening) {
        return 15 - ambientDarkening;
    }

    public int getHeight() {
        return Minecraft.getInstance().level.getHeight();
    }

    public int getMinBuildHeight() {
        return Minecraft.getInstance().level.getMinBuildHeight();
    }

    public static class PredicateAndPos {
        public MultiblockPredicate predicate;
        public BlockPos offset;

        public PredicateAndPos(MultiblockPredicate predicate, BlockPos offset) {
            this.predicate = predicate;
            this.offset = offset;
        }
    }
}

