/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.music;

import com.cmdpro.databank.Databank;
import com.cmdpro.databank.music.MusicController;
import com.cmdpro.databank.music.MusicSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class MusicManager
extends SimpleJsonResourceReloadListener {
    public static HashMap<ResourceLocation, MusicController> musicControllers = new HashMap();
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static MusicManager instance;
    public static MusicSerializer serializer;

    protected MusicManager() {
        super(GSON, "databank/music");
    }

    public static MusicManager getOrCreateInstance() {
        if (instance == null) {
            instance = new MusicManager();
        }
        return instance;
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        musicControllers = new HashMap();
        Databank.LOGGER.info("[DATABANK] Adding Databank Music");
        for (Map.Entry<ResourceLocation, JsonElement> i : pObject.entrySet()) {
            ResourceLocation location = i.getKey();
            if (location.getPath().startsWith("_")) continue;
            try {
                MusicController music = serializer.read(i.getKey(), i.getValue().getAsJsonObject());
                if (music == null) continue;
                musicControllers.put(i.getKey(), music);
            }
            catch (JsonParseException | IllegalArgumentException e) {
                Databank.LOGGER.error("[DATABANK ERROR] Parsing error loading music controller type {}", (Object)location, (Object)e);
            }
        }
        Databank.LOGGER.info("[DATABANK] Loaded {} Music Controllers", (Object)musicControllers.size());
    }

    static {
        serializer = new MusicSerializer();
    }
}

