/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.music.conditions;

import com.cmdpro.databank.music.MusicCondition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class EntityNearbyMusicCondition
extends MusicCondition {
    public EntityType entityType;

    public EntityNearbyMusicCondition(EntityType<?> entityType) {
        this.entityType = entityType;
    }

    @Override
    public boolean isPlaying() {
        for (Entity i : Minecraft.getInstance().level.entitiesForRendering()) {
            if (!i.getType().equals(this.entityType)) continue;
            return true;
        }
        return false;
    }

    public MusicCondition.Serializer getSerializer() {
        return EntityNearbyConditionSerializer.INSTANCE;
    }

    public static class EntityNearbyConditionSerializer
    extends MusicCondition.Serializer {
        public static final EntityNearbyConditionSerializer INSTANCE = new EntityNearbyConditionSerializer();
        public static final MapCodec<EntityNearbyMusicCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.ENTITY_TYPE).fieldOf("entity").xmap(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).get(arg_0), i -> (ResourceKey)BuiltInRegistries.ENTITY_TYPE.getResourceKey(i).orElseThrow()).forGetter(condition -> condition.entityType)).apply((Applicative)instance, EntityNearbyMusicCondition::new));

        public MapCodec<EntityNearbyMusicCondition> codec() {
            return CODEC;
        }
    }
}

