/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.networking.packet;

import com.cmdpro.databank.hidden.ClientHidden;
import com.cmdpro.databank.hidden.HiddenManager;
import com.cmdpro.databank.networking.Message;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record UnlockHiddenSyncS2CPacket(ResourceLocation hidden) implements Message
{
    public static final CustomPacketPayload.Type<UnlockHiddenSyncS2CPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"databank", (String)"unlock_hidden_block_sync"));

    public static UnlockHiddenSyncS2CPacket read(FriendlyByteBuf buf) {
        ResourceLocation block = buf.readResourceLocation();
        return new UnlockHiddenSyncS2CPacket(block);
    }

    public static void write(FriendlyByteBuf buf, UnlockHiddenSyncS2CPacket obj) {
        buf.writeResourceLocation(obj.hidden);
    }

    public CustomPacketPayload.Type<UnlockHiddenSyncS2CPacket> type() {
        return TYPE;
    }

    @Override
    public void handleClient(Minecraft minecraft, Player player) {
        if (!ClientHidden.unlocked.contains(this.hidden) && HiddenManager.hidden.containsKey(this.hidden)) {
            ClientHidden.unlocked.add(this.hidden);
        }
        if (HiddenManager.hidden.containsKey(this.hidden)) {
            HiddenManager.hidden.get((Object)this.hidden).type.getType().updateClient();
        }
    }
}

