/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.networking.packet;

import com.cmdpro.databank.DatabankRegistries;
import com.cmdpro.databank.hidden.ClientHidden;
import com.cmdpro.databank.hidden.HiddenTypeInstance;
import com.cmdpro.databank.networking.Message;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record UnlockedHiddenSyncS2CPacket(List<ResourceLocation> hidden) implements Message
{
    public static final CustomPacketPayload.Type<UnlockedHiddenSyncS2CPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"databank", (String)"unlocked_hidden_block_sync"));

    public static UnlockedHiddenSyncS2CPacket read(FriendlyByteBuf buf) {
        List blocks = buf.readList(FriendlyByteBuf::readResourceLocation);
        return new UnlockedHiddenSyncS2CPacket(blocks);
    }

    public static void write(FriendlyByteBuf buf, UnlockedHiddenSyncS2CPacket obj) {
        buf.writeCollection(obj.hidden, FriendlyByteBuf::writeResourceLocation);
    }

    public CustomPacketPayload.Type<UnlockedHiddenSyncS2CPacket> type() {
        return TYPE;
    }

    @Override
    public void handleClient(Minecraft minecraft, Player player) {
        ClientHidden.unlocked = this.hidden;
        for (HiddenTypeInstance.HiddenType i : DatabankRegistries.HIDDEN_TYPE_REGISTRY.stream().toList()) {
            i.updateClient();
        }
    }
}

