/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.registry;

import com.cmdpro.databank.worldgui.WorldGuiEntity;
import com.cmdpro.databank.worldgui.renderer.WorldGuiRenderer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(value={Dist.CLIENT}, modid="databank", bus=EventBusSubscriber.Bus.MOD)
public class EntityRegistry {
    public static DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"databank");
    public static final Supplier<EntityType<WorldGuiEntity>> WORLD_GUI = EntityRegistry.register("world_gui", () -> EntityType.Builder.of(WorldGuiEntity::new, (MobCategory)MobCategory.MISC).sized(0.0f, 0.0f).build("databank:world_gui"));

    private static <T extends EntityType<?>> Supplier<T> register(String name, Supplier<T> entity) {
        return ENTITY_TYPES.register(name, entity);
    }

    @SubscribeEvent
    public static void clientEntityRenderers(FMLClientSetupEvent event) {
        EntityRenderers.register(WORLD_GUI.get(), WorldGuiRenderer::new);
    }
}

