/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.rendering;

import com.cmdpro.databank.Databank;
import com.cmdpro.databank.rendering.ShaderTypeHandler;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;

public class RenderTypeHandler {
    public static final RenderStateShard.TransparencyStateShard ADDITIVE_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("additive_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static final RenderStateShard.TransparencyStateShard TRANSPARENCY = new RenderStateShard.TransparencyStateShard("transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static List<RenderType> renderTypes = new ArrayList<RenderType>();
    public static List<RenderType> normalRenderTypes = new ArrayList<RenderType>();
    public static List<RenderType> particleRenderTypes = new ArrayList<RenderType>();
    public static final RenderStateShard.ShaderStateShard TRANSLUCENT_SHADER = new RenderStateShard.ShaderStateShard(ShaderTypeHandler::getTranslucent);
    public static final RenderStateShard.ShaderStateShard ADDITIVE_SHADER = new RenderStateShard.ShaderStateShard(ShaderTypeHandler::getAdditive);
    public static final RenderStateShard.ShaderStateShard SCREEN_PROJECTION_SHADER = new RenderStateShard.ShaderStateShard(ShaderTypeHandler::getScreenProjection);
    public static final RenderStateShard.TextureStateShard PARTICLE_SHEET = new RenderStateShard.TextureStateShard(TextureAtlas.LOCATION_PARTICLES, false, false);
    public static final RenderType TRANSPARENT = RenderTypeHandler.registerRenderType((RenderType)RenderType.create((String)"databank:transparent", (VertexFormat)DefaultVertexFormat.PARTICLE, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setLightmapState(RenderStateShard.LIGHTMAP).setTransparencyState(TRANSPARENCY).setShaderState(TRANSLUCENT_SHADER).createCompositeState(false)), true);
    public static final RenderType ADDITIVE = RenderTypeHandler.registerRenderType((RenderType)RenderType.create((String)"databank:additive", (VertexFormat)DefaultVertexFormat.PARTICLE, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setLightmapState(RenderStateShard.LIGHTMAP).setTransparencyState(ADDITIVE_TRANSPARENCY).setShaderState(ADDITIVE_SHADER).createCompositeState(false)), true);
    public static final RenderType TRANSPARENT_PARTICLE = RenderTypeHandler.registerRenderType((RenderType)RenderType.create((String)"databank:transparent", (VertexFormat)DefaultVertexFormat.PARTICLE, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setLightmapState(RenderStateShard.LIGHTMAP).setTransparencyState(TRANSPARENCY).setTextureState((RenderStateShard.EmptyTextureStateShard)PARTICLE_SHEET).setShaderState(TRANSLUCENT_SHADER).createCompositeState(false)), false);
    public static final RenderType ADDITIVE_PARTICLE = RenderTypeHandler.registerRenderType((RenderType)RenderType.create((String)"databank:additive", (VertexFormat)DefaultVertexFormat.PARTICLE, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setLightmapState(RenderStateShard.LIGHTMAP).setTransparencyState(ADDITIVE_TRANSPARENCY).setTextureState((RenderStateShard.EmptyTextureStateShard)PARTICLE_SHEET).setShaderState(ADDITIVE_SHADER).createCompositeState(false)), false);
    public static final RenderType SCREEN_PROJECTION = RenderTypeHandler.registerRenderType((RenderType)RenderType.create((String)"databank:screen_projection", (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(SCREEN_PROJECTION_SHADER).createCompositeState(false)), false);

    public static RenderType registerRenderType(RenderType type, boolean isParticle) {
        renderTypes.add(type);
        if (isParticle) {
            particleRenderTypes.add(type);
        } else {
            normalRenderTypes.add(type);
        }
        return type;
    }

    public static void load() {
        Databank.LOGGER.info("Loaded Databank Render Types");
    }
}

