/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.shaders;

import com.cmdpro.databank.shaders.PostShaderManager;
import com.mojang.blaze3d.pipeline.MainTarget;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public abstract class PostShaderInstance {
    private PostChain postChain;
    public float time;
    public List<PostPass> passes;
    private boolean active;
    public PoseStack viewModelStack;
    private static RenderTarget depthBackupTarget;

    public abstract ResourceLocation getShaderLocation();

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        if (!active) {
            this.time = 0.0f;
        }
        this.active = active;
    }

    public void resize(int pWidth, int pHeight) {
        if (this.postChain != null) {
            this.postChain.resize(pWidth, pHeight);
        }
    }

    public void queueRemoval() {
        if (!PostShaderManager.removalQueue.contains(this)) {
            PostShaderManager.removalQueue.add(this);
        }
    }

    public void process() {
        if (this.postChain == null) {
            try {
                this.postChain = new PostChain(Minecraft.getInstance().getTextureManager(), (ResourceProvider)Minecraft.getInstance().getResourceManager(), Minecraft.getInstance().getMainRenderTarget(), this.getShaderLocation());
                this.postChain.resize(Minecraft.getInstance().getWindow().getWidth(), Minecraft.getInstance().getWindow().getHeight());
                this.passes = this.postChain.passes;
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        if (this.postChain != null) {
            for (PostPass i : this.passes) {
                i.getEffect().safeGetUniform("time").set(this.time + Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true) / 20.0f);
                i.getEffect().safeGetUniform("CameraPosition").set(Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().toVector3f());
                i.getEffect().safeGetUniform("ModelViewMat").set(RenderSystem.getModelViewMatrix());
                i.getEffect().safeGetUniform("invViewMat").set(new Matrix4f((Matrix4fc)PostShaderManager.viewStackMatrix).invert());
                i.getEffect().safeGetUniform("invProjMat").set(new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix()).invert());
                this.setUniforms(i);
            }
            this.beforeProcess();
            if (this.active) {
                this.processPostChain();
                this.afterProcess();
            }
        }
    }

    public void processPostChain() {
        PostShaderInstance.getDepthBackupTarget().copyDepthFrom(Minecraft.getInstance().getMainRenderTarget());
        this.postChain.process(Minecraft.getInstance().getTimer().getGameTimeDeltaTicks());
        Minecraft.getInstance().getMainRenderTarget().copyDepthFrom(PostShaderInstance.getDepthBackupTarget());
        GlStateManager._glBindFramebuffer((int)36009, (int)Minecraft.getInstance().getMainRenderTarget().frameBufferId);
    }

    protected static RenderTarget getDepthBackupTarget() {
        if (depthBackupTarget == null) {
            depthBackupTarget = new MainTarget(Minecraft.getInstance().getMainRenderTarget().width, Minecraft.getInstance().getMainRenderTarget().height);
        }
        return depthBackupTarget;
    }

    public void tick() {
        this.time += 0.05f;
    }

    public void setUniforms(PostPass instance) {
    }

    public void beforeProcess() {
    }

    public void afterProcess() {
    }
}

