/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.worldgui;

import com.cmdpro.databank.worldgui.WorldGuiEntity;
import com.cmdpro.databank.worldgui.WorldGuiHitResult;
import com.cmdpro.databank.worldgui.WorldGuiType;
import com.cmdpro.databank.worldgui.components.WorldGuiComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;

public abstract class WorldGui {
    public WorldGuiEntity entity;
    public List<WorldGuiComponent> components;

    public WorldGui(WorldGuiEntity entity) {
        this.entity = entity;
        this.components = new ArrayList<WorldGuiComponent>();
    }

    public WorldGui addComponent(WorldGuiComponent component) {
        if (!this.components.contains(component)) {
            this.components.add(component);
        }
        return this;
    }

    public WorldGui removeComponent(WorldGuiComponent component) {
        this.components.remove(component);
        return this;
    }

    public WorldGui removeComponents(Predicate<WorldGuiComponent> predicate) {
        this.components.removeAll(this.components.stream().filter(predicate).toList());
        return this;
    }

    public void renderComponents(GuiGraphics guiGraphics) {
        for (WorldGuiComponent i : this.entity.gui.components) {
            i.render(guiGraphics);
        }
    }

    public boolean tryLeftClickComponent(boolean isClient, Player player, WorldGuiComponent component, int x, int y) {
        return true;
    }

    public boolean tryRightClickComponent(boolean isClient, Player player, WorldGuiComponent component, int x, int y) {
        return true;
    }

    public abstract void addInitialComponents();

    public abstract WorldGuiType getType();

    public abstract void sendData(CompoundTag var1);

    public abstract void recieveData(CompoundTag var1);

    public void renderGui(GuiGraphics guiGraphics) {
        this.renderComponents(guiGraphics);
    }

    public void leftClick(boolean isClient, Player player, int x, int y) {
    }

    public void rightClick(boolean isClient, Player player, int x, int y) {
    }

    public void tick() {
    }

    public List<Matrix3f> getMatrixs() {
        return new ArrayList<Matrix3f>();
    }

    public void addMatrixsForFacingPlayer(List<Matrix3f> matrixs, boolean horizontal, boolean vertical) {
        if (this.entity.level().isClientSide) {
            Vec2 angle = ClientHandler.angleToClient(this);
            matrixs.add(new Matrix3f().rotateX((float)Math.toRadians(-90.0)));
            if (horizontal) {
                matrixs.add(new Matrix3f().rotateZ((float)Math.toRadians(-angle.y + 180.0f)));
            }
            if (vertical) {
                matrixs.add(new Matrix3f().rotateX((float)Math.toRadians(-angle.x)));
            }
        }
    }

    public void sync() {
        this.entity.syncData();
    }

    public boolean isPosInBounds(int x, int y, int minX, int minY, int maxX, int maxY) {
        return x >= minX && x <= maxX && y >= minY && y <= maxY;
    }

    public int normalXIntoGuiX(double normalX) {
        return (int)(normalX * (double)this.getType().getRenderSize().x);
    }

    public int normalYIntoGuiY(double normalY) {
        return (int)(normalY * (double)this.getType().getRenderSize().y);
    }

    public Vec2 getClientTargetNormal() {
        WorldGuiEntity entity = ClientHandler.getClientTargetGui();
        if (entity != null && entity.gui == this) {
            return ClientHandler.getClientTargetNormal();
        }
        return null;
    }

    public static Vec2 getClientTargetNormalGlobal() {
        return ClientHandler.getClientTargetNormal();
    }

    private static class ClientHandler {
        private ClientHandler() {
        }

        public static Vec2 getClientTargetNormal() {
            HitResult hitResult = Minecraft.getInstance().hitResult;
            if (hitResult instanceof WorldGuiHitResult) {
                WorldGuiHitResult result = (WorldGuiHitResult)hitResult;
                return result.result.normal;
            }
            return null;
        }

        public static WorldGuiEntity getClientTargetGui() {
            WorldGuiHitResult result;
            Entity entity;
            HitResult hitResult = Minecraft.getInstance().hitResult;
            if (hitResult instanceof WorldGuiHitResult && (entity = (result = (WorldGuiHitResult)hitResult).getEntity()) instanceof WorldGuiEntity) {
                WorldGuiEntity entity2 = (WorldGuiEntity)entity;
                return entity2;
            }
            return null;
        }

        public static Vec2 angleToClient(WorldGui gui) {
            Vec3 pointA = gui.entity.position().multiply(1.0, 1.0, 1.0);
            Vec3 pointB = Minecraft.getInstance().player.getEyePosition().multiply(1.0, 1.0, 1.0);
            return ClientHandler.calculateRotationVector(pointA, pointB);
        }

        private static Vec2 calculateRotationVector(Vec3 pVec, Vec3 pTarget) {
            double d0 = pTarget.x - pVec.x;
            double d1 = pTarget.y - pVec.y;
            double d2 = pTarget.z - pVec.z;
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            return new Vec2(Mth.wrapDegrees((float)((float)(-(Mth.atan2((double)d1, (double)d3) * 57.2957763671875)))), Mth.wrapDegrees((float)((float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f)));
        }
    }
}

