/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.worldgui;

import com.cmdpro.databank.DatabankRegistries;
import com.cmdpro.databank.registry.EntityRegistry;
import com.cmdpro.databank.worldgui.WorldGui;
import com.cmdpro.databank.worldgui.WorldGuiType;
import com.cmdpro.databank.worldgui.components.WorldGuiComponent;
import com.cmdpro.databank.worldgui.components.WorldGuiComponentType;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class WorldGuiEntity
extends Entity {
    public static final EntityDataAccessor<CompoundTag> GUI_DATA = SynchedEntityData.defineId(WorldGuiEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    public WorldGuiType guiType;
    public WorldGui gui;

    public WorldGuiEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public WorldGuiEntity(Level level, Vec3 position, WorldGuiType type) {
        this(EntityRegistry.WORLD_GUI.get(), level);
        this.setPos(position);
        this.guiType = type;
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (!this.level().isClientSide) {
            this.gui = this.guiType.createGui(this);
            this.gui.addInitialComponents();
            this.syncData();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(GUI_DATA, (Object)new CompoundTag());
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.loadGuiData(compound);
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        this.saveGuiData(compound);
    }

    public void sendComponentData(WorldGui gui, CompoundTag tag) {
        ListTag components = new ListTag();
        for (WorldGuiComponent i : gui.components) {
            CompoundTag component = new CompoundTag();
            i.sendData(component);
            component.putUUID("uuid", i.uuid);
            ResourceLocation id = DatabankRegistries.WORLD_GUI_COMPONENT_REGISTRY.getKey((Object)i.getType());
            if (id != null) {
                component.putString("id", id.toString());
            }
            components.add((Object)component);
        }
        tag.put("components", (Tag)components);
    }

    public void recieveComponentData(WorldGui gui, CompoundTag tag) {
        ListTag components = (ListTag)tag.get("components");
        if (components != null) {
            for (Tag i : components) {
                if (!(i instanceof CompoundTag)) continue;
                CompoundTag compoundTag = (CompoundTag)i;
                UUID uuid = compoundTag.getUUID("uuid");
                ResourceLocation id = ResourceLocation.tryParse((String)compoundTag.getString("id"));
                WorldGuiComponentType type = (WorldGuiComponentType)DatabankRegistries.WORLD_GUI_COMPONENT_REGISTRY.get(id);
                if (type == null) continue;
                WorldGuiComponent component = gui.components.stream().filter(j -> j.uuid.equals(uuid)).findFirst().orElse(null);
                if (component == null) {
                    component = type.createComponent(gui);
                }
                component.recieveData(compoundTag);
                component.uuid = uuid;
                gui.addComponent(component);
            }
        }
    }

    public CompoundTag getSyncData() {
        CompoundTag tag = new CompoundTag();
        if (this.guiType.saves()) {
            this.guiType.saveData(this.gui, tag);
        }
        this.gui.sendData(tag);
        this.sendComponentData(this.gui, tag);
        ResourceLocation id = DatabankRegistries.WORLD_GUI_TYPE_REGISTRY.getKey((Object)this.guiType);
        if (id != null) {
            tag.putString("id", id.toString());
        }
        return tag;
    }

    public void syncData() {
        this.getEntityData().set(GUI_DATA, (Object)this.getSyncData());
    }

    public void recieveData(CompoundTag tag) {
        if (this.gui == null || this.guiType == null) {
            ResourceLocation id;
            WorldGuiType type;
            this.gui = null;
            this.guiType = null;
            if (tag.contains("id") && (type = (WorldGuiType)DatabankRegistries.WORLD_GUI_TYPE_REGISTRY.get(id = ResourceLocation.tryParse((String)tag.getString("id")))) != null) {
                this.guiType = type;
                WorldGui worldGui = this.gui = type.saves() ? type.loadData(this, tag) : type.createGui(this);
            }
        }
        if (this.gui != null) {
            this.gui.recieveData(tag);
            this.recieveComponentData(this.gui, tag);
        }
    }

    public void saveComponentData(WorldGui gui, CompoundTag tag) {
        ListTag components = new ListTag();
        for (WorldGuiComponent i : gui.components) {
            CompoundTag component = new CompoundTag();
            i.getType().saveData(i, component);
            ResourceLocation id = DatabankRegistries.WORLD_GUI_COMPONENT_REGISTRY.getKey((Object)i.getType());
            if (id != null) {
                component.putString("id", id.toString());
            }
            components.add((Object)component);
        }
        tag.put("components", (Tag)components);
    }

    public void loadComponentData(WorldGui gui, CompoundTag tag) {
        ListTag components = (ListTag)tag.get("components");
        if (components != null) {
            for (Tag i : components) {
                CompoundTag compoundTag;
                ResourceLocation id;
                WorldGuiComponentType type;
                if (!(i instanceof CompoundTag) || (type = (WorldGuiComponentType)DatabankRegistries.WORLD_GUI_COMPONENT_REGISTRY.get(id = ResourceLocation.tryParse((String)(compoundTag = (CompoundTag)i).getString("id")))) == null) continue;
                WorldGuiComponent component = type.createComponent(gui);
                component.getType().loadData(gui, compoundTag);
            }
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        CompoundTag tag;
        super.onSyncedDataUpdated(key);
        if (key.equals(GUI_DATA) && (tag = (CompoundTag)this.getEntityData().get(GUI_DATA)) != null) {
            this.recieveData(tag);
        }
    }

    public CompoundTag saveGuiData(CompoundTag tag) {
        ResourceLocation id = DatabankRegistries.WORLD_GUI_TYPE_REGISTRY.getKey((Object)this.guiType);
        this.guiType.saveData(this.gui, tag);
        this.saveComponentData(this.gui, tag);
        if (id != null) {
            tag.putString("id", id.toString());
        }
        return tag;
    }

    public void loadGuiData(CompoundTag tag) {
        WorldGuiType type;
        ResourceLocation id = null;
        if (tag.contains("id")) {
            id = ResourceLocation.tryParse((String)tag.getString("id"));
        }
        if ((type = (WorldGuiType)DatabankRegistries.WORLD_GUI_TYPE_REGISTRY.get(id)) != null && type.saves()) {
            this.guiType = type;
            this.gui = type.loadData(this, tag);
            this.loadComponentData(this.gui, tag);
        }
    }

    public Vec3 getBoundsCorner(float multX, float multY) {
        Vec2 size = this.guiType.getMenuWorldSize(this);
        Vector3f vec3 = new Vector3f(size.x / 2.0f * multX, 0.0f, size.y / 2.0f * multY);
        Matrix3f matrix = new Matrix3f();
        List<Matrix3f> matrixs = this.gui.getMatrixs();
        for (Matrix3f i : matrixs) {
            matrix.mul((Matrix3fc)i);
        }
        matrix.transform(vec3);
        Vec3 corner = this.position().add((double)vec3.x, (double)vec3.y, (double)vec3.z);
        return corner;
    }

    public boolean shouldBeSaved() {
        return (this.guiType == null || this.guiType.saves()) && super.shouldBeSaved();
    }

    public void tick() {
        super.tick();
        if (this.gui != null) {
            this.gui.tick();
        }
    }

    public WorldGuiIntersectionResult getLineIntersectResult(Vec3 lineStart, Vec3 lineEnd) {
        Vector3f topLeft = this.getBoundsCorner(-1.0f, 1.0f).toVector3f();
        Vector3f topRight = this.getBoundsCorner(1.0f, 1.0f).toVector3f();
        Vector3f bottomLeft = this.getBoundsCorner(-1.0f, -1.0f).toVector3f();
        Vector3f bottomRight = this.getBoundsCorner(1.0f, -1.0f).toVector3f();
        Vector3f start = lineStart.toVector3f();
        WorldGuiIntersectionResult result1 = this.intersectTriangle(start, lineStart.vectorTo(lineEnd).toVector3f(), (float)lineStart.distanceTo(lineEnd), topLeft, topRight, bottomLeft);
        if (result1 != null) {
            result1 = new WorldGuiIntersectionResult(new Vec2(1.0f - result1.normal.x, result1.normal.y), result1.pos);
            if (result1.normal.length() >= 1.0f) {
                result1.normal = result1.normal.normalized();
            }
            return result1;
        }
        WorldGuiIntersectionResult result2 = this.intersectTriangle(start, lineStart.vectorTo(lineEnd).toVector3f(), (float)lineStart.distanceTo(lineEnd), bottomRight, bottomLeft, topRight);
        if (result2 != null) {
            result2 = new WorldGuiIntersectionResult(new Vec2(result2.normal.x, 1.0f - result2.normal.y), result2.pos);
            if (result2.normal.length() >= 1.0f) {
                result2.normal = result2.normal.normalized();
            }
            return result2;
        }
        return null;
    }

    private WorldGuiIntersectionResult intersectTriangle(Vector3f rayStart, Vector3f direction, float maxDistance, Vector3f triangle1, Vector3f triangle2, Vector3f triangle3) {
        Vector3f e2;
        Vector3f h;
        Vector3f e1 = new Vector3f((Vector3fc)triangle2).sub((Vector3fc)triangle1);
        float a = e1.dot((Vector3fc)(h = new Vector3f((Vector3fc)direction).cross((Vector3fc)(e2 = new Vector3f((Vector3fc)triangle3).sub((Vector3fc)triangle1)))));
        if (a > -1.0E-5f && a < 1.0E-5f) {
            return null;
        }
        float f = 1.0f / a;
        Vector3f s = new Vector3f((Vector3fc)rayStart).sub((Vector3fc)triangle1);
        float u = f * s.dot((Vector3fc)h);
        if (u < 0.0f || u > 1.0f) {
            return null;
        }
        Vector3f q = new Vector3f((Vector3fc)s).cross((Vector3fc)e1);
        float v = f * direction.dot((Vector3fc)q);
        if (v < 0.0f || u + v > 1.0f) {
            return null;
        }
        float t = f * e2.dot((Vector3fc)q);
        Vector3f hitPos = new Vector3f((Vector3fc)rayStart).add((Vector3fc)new Vector3f((Vector3fc)direction).mul(t));
        if (t > 1.0E-5f && t <= maxDistance) {
            return new WorldGuiIntersectionResult(new Vec2(u, v), new Vec3((double)hitPos.x, (double)hitPos.y, (double)hitPos.z));
        }
        return null;
    }

    public static class WorldGuiIntersectionResult {
        public Vec2 normal;
        public Vec3 pos;

        protected WorldGuiIntersectionResult(Vec2 normal, Vec3 pos) {
            this.normal = normal;
            this.pos = pos;
        }
    }
}

