/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.worldgui.components;

import com.cmdpro.databank.worldgui.WorldGui;
import com.cmdpro.databank.worldgui.WorldGuiEntity;
import com.cmdpro.databank.worldgui.WorldGuiHitResult;
import com.cmdpro.databank.worldgui.components.WorldGuiComponentType;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;

public abstract class WorldGuiComponent {
    public UUID uuid;
    public WorldGui gui;

    public abstract void render(GuiGraphics var1);

    public void leftClick(boolean isClient, Player player, int x, int y) {
    }

    public void rightClick(boolean isClient, Player player, int x, int y) {
    }

    public abstract void sendData(CompoundTag var1);

    public abstract void recieveData(CompoundTag var1);

    public abstract WorldGuiComponentType getType();

    public int getDrawPriority() {
        return 0;
    }

    public WorldGuiComponent(WorldGui gui) {
        this.gui = gui;
        this.uuid = UUID.randomUUID();
    }

    public void sync() {
        this.gui.entity.syncData();
    }

    public boolean isPosInBounds(int x, int y, int minX, int minY, int maxX, int maxY) {
        return x >= minX && x <= maxX && y >= minY && y <= maxY;
    }

    public int normalXIntoGuiX(double normalX) {
        return (int)(normalX * (double)this.gui.getType().getRenderSize().x);
    }

    public int normalYIntoGuiY(double normalY) {
        return (int)(normalY * (double)this.gui.getType().getRenderSize().y);
    }

    public Vec2 getClientTargetNormal() {
        WorldGuiEntity entity = ClientHandler.getClientTargetGui();
        if (entity != null && entity.gui == this.gui) {
            return ClientHandler.getClientTargetNormal();
        }
        return null;
    }

    public static Vec2 getClientTargetNormalGlobal() {
        return ClientHandler.getClientTargetNormal();
    }

    private static class ClientHandler {
        private ClientHandler() {
        }

        public static Vec2 getClientTargetNormal() {
            HitResult hitResult = Minecraft.getInstance().hitResult;
            if (hitResult instanceof WorldGuiHitResult) {
                WorldGuiHitResult result = (WorldGuiHitResult)hitResult;
                return result.result.normal;
            }
            return null;
        }

        public static WorldGuiEntity getClientTargetGui() {
            WorldGuiHitResult result;
            Entity entity;
            HitResult hitResult = Minecraft.getInstance().hitResult;
            if (hitResult instanceof WorldGuiHitResult && (entity = (result = (WorldGuiHitResult)hitResult).getEntity()) instanceof WorldGuiEntity) {
                WorldGuiEntity entity2 = (WorldGuiEntity)entity;
                return entity2;
            }
            return null;
        }
    }
}

