/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.world;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class ScaredOfGargoyleGoal
extends Goal {
    public static final String AVOID_TAG_KEY = "ScaredByGargoyle";
    public static final int MAX_DISTANCE_SQR = 256;
    public static final int SPRINT_DISTANCE_SQR = 49;
    private final PathfinderMob mob;
    @Nullable
    private Path path;
    private final PathNavigation navigation;
    @Nullable
    private Vec3 avoiding;

    public static void addGoal(Entity entity) {
        PathfinderMob mob;
        if (entity instanceof PathfinderMob && (mob = (PathfinderMob)entity).m_6336_() == MobType.f_21641_) {
            mob.f_21345_.m_25352_(1, (Goal)new ScaredOfGargoyleGoal(mob));
        }
    }

    public ScaredOfGargoyleGoal(PathfinderMob mob) {
        this.mob = mob;
        this.navigation = mob.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        CompoundTag data = this.mob.getPersistentData();
        if (!data.m_128441_(AVOID_TAG_KEY)) {
            return false;
        }
        BlockPos toAvoid = NbtUtils.m_129239_((CompoundTag)data.m_128469_(AVOID_TAG_KEY));
        this.avoiding = Vec3.m_82512_((Vec3i)toAvoid);
        if (this.mob.m_20238_(this.avoiding) > 256.0) {
            return false;
        }
        Vec3 awayPos = DefaultRandomPos.m_148407_((PathfinderMob)this.mob, (int)16, (int)7, (Vec3)this.avoiding);
        if (awayPos == null) {
            return false;
        }
        if (this.avoiding.m_82557_(awayPos) < this.mob.m_20238_(this.avoiding)) {
            return false;
        }
        this.path = this.navigation.m_26524_(awayPos.f_82479_, awayPos.f_82480_, awayPos.f_82481_, 0);
        return this.path != null;
    }

    public boolean m_8045_() {
        return !this.navigation.m_26571_();
    }

    public void m_8056_() {
        this.navigation.m_26536_(this.path, 1.0);
    }

    public void m_8041_() {
        this.avoiding = null;
        this.mob.getPersistentData().m_128473_(AVOID_TAG_KEY);
    }

    public void m_8037_() {
        if (this.avoiding == null) {
            return;
        }
        if (this.mob.m_20238_(this.avoiding) < 49.0) {
            this.mob.m_21573_().m_26517_(1.3);
        } else {
            this.mob.m_21573_().m_26517_(1.0);
        }
    }
}

