/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import galena.oreganized.content.entity.ShrapnelBomb;
import galena.oreganized.index.OBlocks;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.TntMinecartRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ShrapnelBombRender
extends EntityRenderer<ShrapnelBomb> {
    private final BlockRenderDispatcher blockRenderer;

    public ShrapnelBombRender(EntityRendererProvider.Context context) {
        super(context);
        this.blockRenderer = context.getBlockRenderDispatcher();
    }

    public void render(ShrapnelBomb entity, float yaw, float paritalTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.translate(0.0, 0.5, 0.0);
        int fuse = entity.getFuse();
        if ((float)fuse - paritalTicks + 1.0f < 10.0f) {
            float f = 1.0f - ((float)fuse - paritalTicks + 1.0f) / 10.0f;
            f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
            f *= f;
            f *= f;
            float f1 = 1.0f + f * 0.3f;
            poseStack.scale(f1, f1, f1);
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        poseStack.translate(-0.5, -0.5, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        TntMinecartRenderer.renderWhiteSolidBlock((BlockRenderDispatcher)this.blockRenderer, (BlockState)((Block)OBlocks.SHRAPNEL_BOMB.get()).defaultBlockState(), (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (fuse / 5 % 2 == 0 ? 1 : 0) != 0);
        poseStack.popPose();
        super.render((Entity)entity, yaw, paritalTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(ShrapnelBomb entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

