/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public interface ISilver {
    public static final float RANGE = 24.0f;

    default public List<Entity> getEntities(Level world, BlockPos pos, @Nullable Player player) {
        return world.getEntities((Entity)player, new AABB((double)((float)pos.getX() + 24.0f), (double)((float)pos.getY() + 24.0f), (double)((float)pos.getZ() + 24.0f), (double)((float)pos.getX() - 24.0f), (double)((float)pos.getY() - 24.0f), (double)((float)pos.getZ() - 24.0f)), living -> living instanceof LivingEntity && ((LivingEntity)living).isInvertedHealAndHarm());
    }

    default public boolean isUndeadNearby(Level world, BlockPos pos, @Nullable Player player) {
        for (Entity e : this.getEntities(world, pos, player)) {
            LivingEntity living = (LivingEntity)e;
            if (!living.isInvertedHealAndHarm()) continue;
            return true;
        }
        return false;
    }

    default public int getUndeadDistance(Level world, BlockPos pos, @Nullable Player player, int frames) {
        int dist = frames;
        for (Entity e : this.getEntities(world, pos, player)) {
            LivingEntity living = (LivingEntity)e;
            double distance = player != null ? (double)living.distanceTo((Entity)player) : Math.sqrt(living.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()));
            double ceil = Math.ceil(distance / (double)(24.0f / (float)frames));
            if (!(distance < 24.0) || (int)ceil >= dist || (dist = distance < 6.0 ? 1 : Math.max((int)ceil, 2)) <= frames) continue;
            dist = frames;
        }
        if (!this.isUndeadNearby(world, pos, player)) {
            dist = frames;
        }
        return dist;
    }
}

