/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.block;

import com.mojang.serialization.MapCodec;
import galena.oreganized.content.entity.GargoyleBlockEntity;
import galena.oreganized.index.OBlockEntities;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GargoyleBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    private static final MapCodec<GargoyleBlock> CODEC = GargoyleBlock.simpleCodec(GargoyleBlock::new);
    public static final EnumProperty<AttachmentType> ATTACHMENT = EnumProperty.create((String)"attachment", AttachmentType.class);
    public final Map<BlockState, VoxelShape> SHAPES = this.getShapeForEachState(this::getShapeFor);
    public static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = (source, stack) -> {
        BlockState dispenser = source.state();
        Direction facing = (Direction)dispenser.getValue((Property)DispenserBlock.FACING);
        BlockPos targetPos = source.pos().relative(facing);
        BlockEntity target = source.level().getBlockEntity(targetPos);
        if (target instanceof GargoyleBlockEntity) {
            GargoyleBlockEntity gargoyle = (GargoyleBlockEntity)target;
            gargoyle.interact((Level)source.level(), targetPos, null, stack, false);
        }
        return stack;
    };

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public GargoyleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue(ATTACHMENT, (Comparable)((Object)AttachmentType.FLOOR)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING, ATTACHMENT});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState base = super.getStateForPlacement(context);
        Direction clickedFace = context.getClickedFace();
        if (clickedFace.getAxis().isHorizontal() && !context.replacingClickedOnBlock()) {
            return (BlockState)((BlockState)base.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)clickedFace.getOpposite())).setValue(ATTACHMENT, (Comparable)((Object)AttachmentType.WALL));
        }
        return (BlockState)((BlockState)base.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection())).setValue(ATTACHMENT, (Comparable)((Object)AttachmentType.FLOOR));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (type != OBlockEntities.GARGOYLE.get()) {
            return null;
        }
        BlockEntityTicker ticker = GargoyleBlockEntity::tick;
        return ticker;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof GargoyleBlockEntity) {
            GargoyleBlockEntity gargoyle = (GargoyleBlockEntity)blockEntity;
            return gargoyle.getAnalogOutputSignal();
        }
        return super.getAnalogOutputSignal(state, level, pos);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof GargoyleBlockEntity) {
            GargoyleBlockEntity gargoyle = (GargoyleBlockEntity)blockEntity;
            return gargoyle.interact(level, pos, player, stack, false);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    public static void dripParticles(BlockState state, Level level, BlockPos pos, RandomSource random, ParticleOptions type) {
        double spread = random.nextDouble() * 0.1 - 0.05;
        Vec3 offset = AttachmentType.offset(state, pos, spread);
        level.addParticle(type, offset.x, offset.y, offset.z, 0.0, 0.0, 0.0);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GargoyleBlockEntity(pos, state);
    }

    protected VoxelShape getShapeFor(BlockState state) {
        boolean zSize;
        Direction facing = (Direction)state.getValue((Property)FACING);
        AttachmentType attachment = (AttachmentType)((Object)state.getValue(ATTACHMENT));
        boolean xOffset = facing == Direction.EAST;
        boolean xSize = facing.getAxis() == Direction.Axis.X;
        boolean zOffset = facing == Direction.SOUTH;
        boolean bl = zSize = facing.getAxis() == Direction.Axis.Z;
        if (attachment == AttachmentType.FLOOR) {
            VoxelShape base = GargoyleBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
            VoxelShape legs = GargoyleBlock.box((double)((double)xOffset * 11.0), (double)2.0, (double)((double)zOffset * 11.0), (double)((double)xOffset * 11.0 + 5.0 * (double)xSize + 16.0 * (double)zSize), (double)12.0, (double)((double)zOffset * 11.0 + 5.0 * (double)zSize + 16.0 * (double)xSize));
            VoxelShape arms = GargoyleBlock.box((double)((double)xOffset * 12.0 + (double)zSize - (double)facing.getStepX() * 7.0), (double)2.0, (double)((double)zOffset * 12.0 + (double)xSize - (double)facing.getStepZ() * 7.0), (double)((double)xOffset * 12.0 + 4.0 * (double)xSize + 15.0 * (double)zSize - (double)facing.getStepX() * 7.0), (double)17.0, (double)((double)zOffset * 12.0 + 4.0 * (double)zSize + 15.0 * (double)xSize - (double)facing.getStepZ() * 7.0));
            VoxelShape body = GargoyleBlock.box((double)((double)zSize * 2.0 + (double)xOffset * 5.0 + 1.0), (double)7.0, (double)((double)xSize * 2.0 + (double)zOffset * 5.0 + 1.0), (double)((double)xSize * 10.0 + (double)xOffset * 5.0 + (double)zSize * 13.0), (double)16.0, (double)((double)zSize * 10.0 + (double)zOffset * 5.0 + (double)xSize * 13.0));
            VoxelShape head = GargoyleBlock.box((double)((double)zSize * 4.0 + (double)xSize * 10.0 - (double)xOffset * 10.0), (double)7.0, (double)((double)xSize * 4.0 + (double)zSize * 10.0 - (double)zOffset * 10.0), (double)((double)zSize * 12.0 + (double)xSize * 16.0 - (double)xOffset * 10.0), (double)15.0, (double)((double)xSize * 12.0 + (double)zSize * 16.0 - (double)zOffset * 10.0));
            return Shapes.or((VoxelShape)base, (VoxelShape[])new VoxelShape[]{legs, arms, body, head});
        }
        if (attachment == AttachmentType.WALL) {
            VoxelShape base = GargoyleBlock.box((double)((double)xOffset * 14.0), (double)0.0, (double)((double)zOffset * 14.0), (double)((double)xOffset * 14.0 + 2.0 * (double)xSize + 16.0 * (double)zSize), (double)16.0, (double)((double)zOffset * 14.0 + 2.0 * (double)zSize + 16.0 * (double)xSize));
            VoxelShape head = GargoyleBlock.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0).move((double)facing.getStepX() * -1.25, 0.3125, (double)facing.getStepZ() * -1.25).move((double)xOffset * 0.5, 0.0, (double)zOffset * 0.5).move((double)zSize * 0.25, 0.0, (double)xSize * 0.25);
            VoxelShape body = GargoyleBlock.box((double)0.0, (double)0.0, (double)0.0, (double)9.0, (double)9.0, (double)9.0).move((double)facing.getStepX() * -11.0 / 16.0, 0.4375, (double)facing.getStepZ() * -11.0 / 16.0).move((double)xOffset * 7.0 / 16.0, 0.0, (double)zOffset * 7.0 / 16.0).move((double)zSize * 0.25, 0.0, (double)xSize * 0.25);
            VoxelShape log = GargoyleBlock.box((double)((double)xOffset * 14.0), (double)0.0, (double)((double)zOffset * 14.0), (double)((double)xOffset * 14.0 + 4.0 * (double)xSize + 4.0 * (double)zSize), (double)4.0, (double)((double)zOffset * 14.0 + 4.0 * (double)zSize + 16.0 * (double)xSize)).move((double)xSize * 0.125 - (double)xOffset * 0.375, 0.0, (double)zSize * 0.125 - (double)zOffset * 0.375);
            return Shapes.or((VoxelShape)base, (VoxelShape[])new VoxelShape[]{body, head, log});
        }
        return GargoyleBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.SHAPES.get(state);
    }

    public static enum AttachmentType implements StringRepresentable
    {
        FLOOR("floor", 0.55, 0.2),
        WALL("wall", 1.3, 0.12);

        private final String name;
        private final double horizontalOffset;
        private final double verticalOffset;

        private AttachmentType(String name, double horizontalOffset, double verticalOffset) {
            this.name = name;
            this.horizontalOffset = horizontalOffset;
            this.verticalOffset = verticalOffset;
        }

        public static Vec3 offset(BlockState state, BlockPos pos, double spread) {
            Direction facing = ((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite();
            AttachmentType attachment = (AttachmentType)((Object)state.getValue(ATTACHMENT));
            double offsetX = facing.getAxis() == Direction.Axis.X ? (double)facing.getStepX() * attachment.horizontalOffset : spread;
            double offsetZ = facing.getAxis() == Direction.Axis.Z ? (double)facing.getStepZ() * attachment.horizontalOffset : spread;
            double x = (double)pos.getX() + 0.5 + offsetX;
            double y = (double)pos.getY() + attachment.verticalOffset + 0.05;
            double z = (double)pos.getZ() + 0.5 + offsetZ;
            return new Vec3(x, y, z);
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

