/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.block;

import galena.oreganized.index.OTags;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public interface IMeltableBlock {
    public static final IntegerProperty GOOPYNESS_3 = IntegerProperty.create((String)"goopyness", (int)0, (int)2);
    public static final List<BlockPos> OFFSET = List.of(new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 1, 0), new BlockPos(0, -1, 0), new BlockPos(0, 0, 1), new BlockPos(0, 0, -1));

    default public IntegerProperty getGoopynessProperty() {
        return GOOPYNESS_3;
    }

    default public int getGoopyness(BlockState state) {
        return (Integer)state.getValue((Property)this.getGoopynessProperty());
    }

    public static int getLightLevel(BlockState state) {
        return switch ((Integer)state.getValue((Property)GOOPYNESS_3)) {
            case 2 -> 6;
            case 1 -> 3;
            default -> 0;
        };
    }

    default public int getInducedGoopyness(BlockGetter world, BlockState state, BlockPos pos, BlockState selfState, BlockPos selfPos) {
        IMeltableBlock meltable;
        if (state.is(OTags.Blocks.MELTS_LEAD)) {
            return 2;
        }
        Block block = state.getBlock();
        if (block instanceof IMeltableBlock && (meltable = (IMeltableBlock)block).getGoopyness(state) == 2) {
            return 1;
        }
        if (state.getLightEmission(world, pos) >= 15) {
            return 1;
        }
        return 0;
    }

    default public int goopynessAt(BlockGetter world, BlockState selfState, BlockPos selfPos) {
        OptionalInt touching = OFFSET.stream().map(arg_0 -> ((BlockPos)selfPos).offset(arg_0)).mapToInt(pos -> this.getInducedGoopyness(world, world.getBlockState(pos), (BlockPos)pos, selfState, selfPos)).max();
        return touching.orElse(0);
    }

    default public int getNextGoopyness(BlockGetter world, BlockState selfState, BlockPos selfPos) {
        return this.goopynessAt(world, selfState, selfPos);
    }

    default public boolean onGoopynessChange(Level world, BlockState state, BlockPos pos, RandomSource random, int from, int to) {
        return true;
    }

    default public void tickMelting(BlockState state, Level world, BlockPos pos, RandomSource random) {
        int goopyness;
        int currentGoopyness = (Integer)state.getValue((Property)this.getGoopynessProperty());
        if (currentGoopyness != (goopyness = this.getNextGoopyness((BlockGetter)world, state, pos)) && this.onGoopynessChange(world, state, pos, random, currentGoopyness, goopyness)) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)this.getGoopynessProperty(), (Comparable)Integer.valueOf(goopyness)));
        }
        this.scheduleUpdate(world, pos, state.getBlock());
    }

    default public void hurt(BlockState state, Level world, Entity entity) {
        LivingEntity le;
        if (this.getGoopyness(state) < 2) {
            return;
        }
        if (!entity.isSteppingCarefully() && entity instanceof LivingEntity && EnchantmentHelper.hasTag((ItemStack)(le = (LivingEntity)entity).getItemBySlot(EquipmentSlot.FEET), OTags.Enchantments.HEAD_IMMUNITY)) {
            entity.hurt(world.damageSources().hotFloor(), 1.0f);
        }
    }

    default public void scheduleUpdate(Level level, BlockPos pos, Block block) {
        level.scheduleTick(pos, block, level.random.nextInt(30, 60));
    }
}

