/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.block;

import galena.oreganized.content.block.HeavyDoorBlockEntity;
import galena.oreganized.content.block.IHeavyDoor;
import galena.oreganized.content.block.IMeltableBlock;
import galena.oreganized.index.OBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class LeadTrapdoorBlock
extends TrapDoorBlock
implements IMeltableBlock,
EntityBlock,
IHeavyDoor {
    public LeadTrapdoorBlock(BlockBehaviour.Properties properties) {
        super(OBlocks.LEAD_BLOCK_SET, properties);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new HeavyDoorBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return HeavyDoorBlockEntity.getTicker(level, state, type);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return HeavyDoorBlockEntity.getAt((LevelAccessor)level, pos).map(it -> it.use(state, level, pos, player)).orElse(ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{this.getGoopynessProperty()});
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.tickMelting(state, (Level)world, pos, random);
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
        this.hurt(state, world, entity);
        super.stepOn(world, pos, state, entity);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        this.scheduleUpdate(level, pos, block);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        this.scheduleUpdate(level, pos, state.getBlock());
    }

    @Override
    public void sound(@Nullable Player player, Level level, BlockPos pos, boolean open) {
        this.playSound(player, level, pos, open);
    }
}

