/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.block;

import galena.oreganized.OreganizedConfig;
import galena.oreganized.content.block.LeadOreBlock;
import galena.oreganized.content.block.MeltableBlock;
import galena.oreganized.index.OBlocks;
import galena.oreganized.index.OItems;
import galena.oreganized.index.OTags;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MoltenLeadBlock
extends LiquidBlock {
    public static final VoxelShape STABLE_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final BooleanProperty WAITING = BooleanProperty.create((String)"waiting");

    public MoltenLeadBlock(Supplier<? extends FlowingFluid> fluid, BlockBehaviour.Properties properties) {
        super(fluid.get(), properties.noCollission().strength(-1.0f, 3600000.0f).noLootTable().lightLevel(state -> 8));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WAITING, (Comparable)Boolean.valueOf(true)));
    }

    public PathType getAdjacentBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, PathType originalType) {
        return PathType.WALKABLE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WAITING});
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.getFluidState().isSource()) {
            FluidState oldFluid = oldState.getFluidState();
            if (oldFluid.is(FluidTags.WATER)) {
                level.levelEvent(1501, pos, 0);
                level.setBlock(pos, ((MeltableBlock)OBlocks.LEAD_BLOCK.get()).defaultBlockState(), 3);
            } else if (oldFluid.is(FluidTags.LAVA)) {
                LeadOreBlock.spawnCloud(level, pos, 2.0f);
                level.setBlockAndUpdate(pos, oldState);
            }
        }
        if (((Boolean)state.getValue((Property)WAITING)).booleanValue()) {
            level.scheduleTick(pos, state.getBlock(), ((Integer)OreganizedConfig.COMMON.moltenLeadDelay.get()).intValue());
        }
        super.onPlace(state, level, pos, oldState, isMoving);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (context.isHoldingItem((Item)OItems.MOLTEN_LEAD_BUCKET.get())) {
            return level.getBlockState(pos.above()).is((Block)this) ? Shapes.block() : STABLE_SHAPE;
        }
        return Shapes.empty();
    }

    public boolean canBeReplaced(BlockState state, Fluid fluid) {
        if (this.fluid == fluid) {
            return false;
        }
        return super.canBeReplaced(state, fluid);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState replacedWith, boolean dropXp) {
        super.onRemove(state, level, pos, replacedWith, dropXp);
        if (replacedWith.isAir() || !replacedWith.getFluidState().isEmpty()) {
            return;
        }
        if (replacedWith.is((Block)OBlocks.LEAD_BLOCK.get())) {
            return;
        }
        if (state.getFluidState().isSource()) {
            this.tryEscape(state, level, pos);
        }
    }

    private boolean tryEscape(BlockState state, Level level, BlockPos pos, Direction direction) {
        BlockPos adjancentPos = pos.relative(direction);
        BlockState adjacentState = level.getBlockState(adjancentPos);
        if (adjacentState.canBeReplaced((Fluid)this.fluid)) {
            level.setBlockAndUpdate(adjancentPos, state);
            this.getPickupSound().ifPresent(sound -> level.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f));
            return true;
        }
        return false;
    }

    private boolean tryEscape(BlockState state, Level level, BlockPos pos) {
        if (this.tryEscape(state, level, pos, Direction.DOWN)) {
            return true;
        }
        for (Direction direction : Direction.allShuffled((RandomSource)level.random)) {
            if (!direction.getAxis().isHorizontal() || !this.tryEscape(state, level, pos, direction)) continue;
            return true;
        }
        return this.tryEscape(state, level, pos, Direction.UP);
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (entity.getY() < (double)pos.getY() + STABLE_SHAPE.max(Direction.Axis.Y)) {
            if (!(entity instanceof LivingEntity) || entity.getBlockStateOn().is((Block)this)) {
                entity.makeStuckInBlock(state, new Vec3((double)0.9f, 1.0, (double)0.9f));
            }
            entity.setRemainingFireTicks(200);
            if (!world.isClientSide) {
                entity.setSharedFlagOnFire(true);
            }
        }
    }

    public void fallOn(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if ((double)fallDistance >= 4.0 && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            LivingEntity.Fallsounds fallSound = living.getFallSounds();
            SoundEvent sound = (double)fallDistance < 7.0 ? fallSound.small() : fallSound.big();
            entity.playSound(sound, 1.0f, 1.0f);
        }
    }

    public static boolean isEntityLighterThanLead(Entity entity) {
        LivingEntity living;
        if (entity.getType().is(OTags.Entities.LIGHTER_THAN_LEAD)) {
            return true;
        }
        return entity instanceof LivingEntity && (living = (LivingEntity)entity).getItemBySlot(EquipmentSlot.FEET).is(OTags.Items.LIGHTER_THAN_LEAD);
    }

    public static boolean shouldWait(LevelAccessor level, BlockPos pos) {
        BlockPos belowPos = pos.below();
        BlockState belowState = level.getBlockState(belowPos);
        return belowState.isFaceSturdy((BlockGetter)level, belowPos, Direction.UP);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighborPos, boolean moving) {
        super.neighborChanged(state, level, pos, block, neighborPos, moving);
        Boolean waiting = (Boolean)state.getValue((Property)WAITING);
        boolean shouldWait = MoltenLeadBlock.shouldWait((LevelAccessor)level, pos);
        if (waiting == shouldWait) {
            return;
        }
        if (shouldWait) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)WAITING, (Comparable)Boolean.valueOf(true)));
        } else {
            level.scheduleTick(pos, state.getBlock(), ((Integer)OreganizedConfig.COMMON.moltenLeadDelay.get()).intValue());
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.tick(state, level, pos, random);
        if (!MoltenLeadBlock.shouldWait((LevelAccessor)level, pos)) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)WAITING, (Comparable)Boolean.valueOf(false)));
        }
    }

    public Optional<SoundEvent> getPickupSound() {
        return Optional.of(SoundEvents.BUCKET_FILL_LAVA);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return true;
    }
}

