/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.block;

import com.mojang.serialization.MapCodec;
import galena.oreganized.OreganizedConfig;
import galena.oreganized.index.OBlocks;
import galena.oreganized.index.OItems;
import galena.oreganized.index.OTags;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class MoltenLeadCauldronBlock
extends AbstractCauldronBlock
implements CauldronInteraction {
    private static final MapCodec<MoltenLeadCauldronBlock> CODEC = MoltenLeadCauldronBlock.simpleCodec(MoltenLeadCauldronBlock::new);
    public static final CauldronInteraction.InteractionMap INTERACTION_MAP = CauldronInteraction.newInteractionMap((String)"oreganized:lead");
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    public static final CauldronInteraction FILL_MOLTEN_LEAD = (state, world, pos, player, hand, stack) -> CauldronInteraction.emptyBucket((Level)world, (BlockPos)pos, (Player)player, (InteractionHand)hand, (ItemStack)stack, (BlockState)((BlockState)((Block)OBlocks.MOLTEN_LEAD_CAULDRON.get()).defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(3))), (SoundEvent)SoundEvents.BUCKET_EMPTY_LAVA);
    public static final CauldronInteraction EMPTY_MOLTEN_LEAD = (state, world, pos, player, hand, stack) -> CauldronInteraction.fillBucket((BlockState)state, (Level)world, (BlockPos)pos, (Player)player, (InteractionHand)hand, (ItemStack)stack, (ItemStack)new ItemStack((ItemLike)OItems.MOLTEN_LEAD_BUCKET.get()), blockState -> ((Integer)state.getValue((Property)AGE)).equals(3), (SoundEvent)SoundEvents.BUCKET_FILL_LAVA);
    public static final CauldronInteraction FILL_LEAD_BLOCK = (state, world, pos, player, hand, stack) -> MoltenLeadCauldronBlock.placeBlock(world, pos, player, hand, stack, (BlockState)((Block)OBlocks.MOLTEN_LEAD_CAULDRON.get()).defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0)), SoundEvents.METAL_PLACE);
    public static final CauldronInteraction EMPTY_LEAD_BLOCK = (state, world, pos, player, hand, stack) -> MoltenLeadCauldronBlock.dropResource(state, world, pos, player, hand, stack, new ItemStack((ItemLike)OBlocks.LEAD_BLOCK.get()), blockState -> ((Integer)state.getValue((Property)AGE)).equals(0), SoundEvents.ITEM_FRAME_REMOVE_ITEM);

    protected MapCodec<? extends AbstractCauldronBlock> codec() {
        return CODEC;
    }

    public MoltenLeadCauldronBlock(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(MoltenLeadCauldronBlock.moltenStageEmission()), INTERACTION_MAP);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)Items.CAULDRON);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    protected double getContentHeight(BlockState state) {
        return 0.9375;
    }

    public static ToIntFunction<BlockState> moltenStageEmission() {
        return state -> (Integer)state.getValue((Property)AGE) * 2;
    }

    public boolean isFull(BlockState state) {
        return true;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        if (!((Integer)state.getValue((Property)AGE)).equals(3)) {
            return Shapes.block();
        }
        return super.getShape(state, world, pos, ctx);
    }

    public void entityInside(BlockState state, Level level, BlockPos blockPos, Entity entity) {
        if (this.isEntityInsideContent(state, blockPos, entity)) {
            entity.setRemainingFireTicks(10);
        }
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos blockPos) {
        return (Integer)state.getValue((Property)AGE) + 1;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.tick(state, world, pos, random);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!world.isAreaLoaded(pos, 1)) {
            return;
        }
        int max_age = AGE.getPossibleValues().size() - 1;
        int age = (Integer)state.getValue((Property)AGE);
        if (age < max_age && random.nextInt(1) == 0) {
            BlockState below = world.getBlockState(pos.below());
            if ((below.is(OTags.Blocks.FIRE_SOURCE) || below.getFluidState().is(FluidTags.LAVA)) && ((Boolean)OreganizedConfig.COMMON.cauldronLeadMelting.get()).booleanValue()) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
                return;
            }
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(Mth.clamp((int)(age - 1), (int)0, (int)max_age))));
        }
    }

    @NotNull
    public ItemInteractionResult interact(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        ItemStack itemstack = player.getItemInHand(hand);
        CauldronInteraction cauldroninteraction = (CauldronInteraction)INTERACTION_MAP.map().get(itemstack.getItem());
        return cauldroninteraction.interact(state, world, pos, player, hand, itemstack);
    }

    static ItemInteractionResult placeBlock(Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack stack, BlockState state, SoundEvent sound) {
        if (!world.isClientSide) {
            Item item = stack.getItem();
            player.awardStat(Stats.FILL_CAULDRON);
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            world.setBlockAndUpdate(pos, state);
            world.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.gameEvent(null, (Holder)GameEvent.BLOCK_PLACE, pos);
        }
        return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    static ItemInteractionResult dropResource(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack usedStack, ItemStack droppedStack, Predicate<BlockState> stateCondition, SoundEvent sound) {
        if (!stateCondition.test(state)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!world.isClientSide) {
            Item item = usedStack.getItem();
            player.awardStat(Stats.USE_CAULDRON);
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            MoltenLeadCauldronBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)droppedStack);
            world.setBlockAndUpdate(pos, Blocks.CAULDRON.defaultBlockState());
            world.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
    }
}

