/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.block;

import galena.oreganized.Oreganized;
import galena.oreganized.index.OBlocks;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SpottedGlanceBlock
extends Block {
    public static final ResourceKey<LootTable> WASH_LOOT_TABLE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Oreganized.modLoc("gameplay/spotted_glance"));

    public SpottedGlanceBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState adjState, LevelAccessor world, BlockPos pos, BlockPos adjPos) {
        if (!world.isWaterAt(adjPos)) {
            return super.updateShape(state, direction, adjState, world, pos, adjPos);
        }
        this.dropLeadNuggets(world, pos);
        return ((Block)OBlocks.GLANCE.get()).defaultBlockState();
    }

    private void dropLeadNuggets(LevelAccessor level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            LootTable lootTable = level.getServer().reloadableRegistries().getLootTable(WASH_LOOT_TABLE);
            LootParams params = new LootParams.Builder((ServerLevel)level).withLuck(((ServerLevel)level).random.nextFloat()).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.BLOCK_STATE, (Object)level.getBlockState(pos)).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).create(LootContextParamSets.BLOCK);
            ObjectArrayList drops = lootTable.getRandomItems(params);
            drops.forEach(drop -> Containers.dropItemStack((Level)((Level)level), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)drop));
        }
    }
}

