/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.effect;

import galena.oreganized.Oreganized;
import galena.oreganized.content.critera.DummyCriterionTrigger;
import galena.oreganized.index.OCriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.jetbrains.annotations.NotNull;

public class StunningEffect
extends MobEffect {
    private static final ResourceLocation SLOWNESS_ID = Oreganized.modLoc("stunning_slowness_debuff");
    public static final int MAX_AMPLIFIER = 9;

    public StunningEffect() {
        super(MobEffectCategory.HARMFUL, 7235236);
        this.addAttributeModifier(Attributes.MOVEMENT_SPEED, SLOWNESS_ID, -0.075, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    public boolean applyEffectTick(@NotNull LivingEntity entity, int amplifier) {
        int step;
        if (entity.level().getGameTime() % 5L != 0L) {
            return true;
        }
        float health = entity.getHealth() / entity.getMaxHealth();
        int targetAmplifier = (int)Math.ceil((1.0 - (double)health) * 9.0);
        if (entity.getHealth() <= 1.0f && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ((DummyCriterionTrigger)((Object)OCriteriaTriggers.PROFOUND_BRAIN_DAMAGE.get())).trigger(player);
        }
        if (targetAmplifier == amplifier) {
            return true;
        }
        Holder holder = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)this);
        MobEffectInstance instance = entity.getEffect(holder);
        if (instance == null) {
            return true;
        }
        int n = step = targetAmplifier > amplifier ? 1 : -1;
        if (instance.update(new MobEffectInstance(instance.getEffect(), instance.getDuration() + 1, amplifier + step, instance.isAmbient(), instance.isVisible(), instance.showIcon()))) {
            this.addAttributeModifiers(entity.getAttributes(), instance.getAmplifier());
            if (entity.level().isClientSide) {
                entity.level().playSound((Entity)entity, entity.blockPosition(), SoundEvents.SCULK_BLOCK_SPREAD, SoundSource.PLAYERS, (float)instance.getAmplifier() * 0.8f / 9.0f + 0.2f, entity.getRandom().nextFloat() * 0.2f + 0.8f);
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int p_295329_, int p_295167_) {
        return true;
    }
}

