/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.fluid;

import galena.oreganized.content.block.MoltenLeadBlock;
import galena.oreganized.index.OParticleTypes;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidInteractionRegistry;

@ParametersAreNonnullByDefault
public class MoltenLeadFluid
extends BaseFlowingFluid {
    public MoltenLeadFluid(BaseFlowingFluid.Properties properties) {
        super(properties);
        this.registerDefaultState((FluidState)((FluidState)this.defaultFluidState().setValue((Property)LEVEL, (Comparable)Integer.valueOf(8))).setValue((Property)FALLING, (Comparable)Boolean.valueOf(false)));
    }

    protected boolean isRandomlyTicking() {
        return true;
    }

    public int getAmount(FluidState state) {
        return 8;
    }

    public boolean isSource(FluidState state) {
        return (Boolean)state.getValue((Property)FALLING) == false;
    }

    protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
        super.createFluidStateDefinition(builder);
        builder.add(new Property[]{LEVEL});
    }

    protected void spread(Level level, BlockPos pos, FluidState fluidState) {
        if (fluidState.isEmpty()) {
            return;
        }
        BlockState blockstate = level.getBlockState(pos);
        if (((Boolean)blockstate.getValue((Property)MoltenLeadBlock.WAITING)).booleanValue()) {
            return;
        }
        BlockPos belowPos = pos.below();
        BlockState belowState = level.getBlockState(belowPos);
        boolean leadBelow = belowState.getFluidState().is((Fluid)this);
        if (fluidState.isSource()) {
            if (leadBelow && !belowState.getFluidState().isSource() || !leadBelow && !belowState.getFluidState().isEmpty()) {
                if (!FluidInteractionRegistry.canInteract((Level)level, (BlockPos)belowPos)) {
                    this.spreadTo((LevelAccessor)level, belowPos, belowState, Direction.DOWN, fluidState);
                }
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            } else if (this.canSpreadTo((BlockGetter)level, pos, blockstate, Direction.DOWN, belowPos, belowState, level.getFluidState(belowPos), fluidState.getType())) {
                this.spreadTo((LevelAccessor)level, belowPos, belowState, Direction.DOWN, (FluidState)fluidState.setValue((Property)FALLING, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    protected void spreadTo(LevelAccessor level, BlockPos pos, BlockState state, Direction direction, FluidState fluid) {
        if (!state.isAir()) {
            this.beforeDestroyingBlock(level, pos, state);
        }
        level.setBlock(pos, (BlockState)fluid.createLegacyBlock().setValue((Property)MoltenLeadBlock.WAITING, (Comparable)Boolean.valueOf(MoltenLeadBlock.shouldWait(level, pos))), 3);
    }

    protected void beforeDestroyingBlock(LevelAccessor level, BlockPos pos, BlockState state) {
        if (state.getFluidState().is((Fluid)this)) {
            return;
        }
        level.levelEvent(1501, pos, 0);
    }

    public void animateTick(Level world, BlockPos blockPos, FluidState fluidState, RandomSource random) {
        BlockPos abovePos = blockPos.above();
        if (world.getBlockState(abovePos).isAir() && !world.getBlockState(abovePos).isSolidRender((BlockGetter)world, abovePos) && random.nextInt(300) == 0) {
            world.playLocalSound((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), SoundEvents.LAVA_AMBIENT, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
        }
    }

    @Nullable
    public ParticleOptions getDripParticle() {
        return (ParticleOptions)OParticleTypes.DRIPPING_LEAD.get();
    }
}

