/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.item;

import galena.oreganized.client.accessors.GuiAccessor;
import galena.oreganized.client.tooltips.DeviceTooltip;
import galena.oreganized.index.ODataComponents;
import galena.oreganized.index.OItems;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="oreganized")
public class DeviceItem
extends Item {
    public static final int FRAMES = 10;
    public static final int TOOLTIP_COLOR = 9183509;

    public DeviceItem(Item.Properties properties) {
        super(properties);
    }

    private static void generateValue(ItemStack stack, RandomSource random) {
        stack.set(ODataComponents.DEVICE_VALUE, (Object)random.nextInt(999999));
    }

    private static void clearValue(ItemStack stack) {
        stack.remove(ODataComponents.DEVICE_VALUE);
    }

    public static Optional<Integer> getValue(ItemStack stack) {
        return Optional.ofNullable((Integer)stack.get(ODataComponents.DEVICE_VALUE));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        Gui gui;
        ItemStack stack = player.getItemInHand(hand);
        if (DeviceItem.getValue(stack).isPresent()) {
            return super.use(level, player, hand);
        }
        DeviceItem.generateValue(stack, player.getRandom());
        player.playSound(SoundEvents.LODESTONE_COMPASS_LOCK, 1.0f, 1.5f);
        if (level.isClientSide() && (gui = Minecraft.getInstance().gui) instanceof GuiAccessor) {
            GuiAccessor accessor = (GuiAccessor)gui;
            accessor.oreganized$setToolHighlightTimer(60);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return DeviceItem.getValue(stack).stream().map(DeviceTooltip::new).findAny();
    }

    @SubscribeEvent
    public static void onHitAir(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack stack = event.getItemStack();
        if (!stack.is((Item)OItems.UNKNOWN_DEVICE.get())) {
            return;
        }
        event.getEntity().playSound(SoundEvents.AMETHYST_BLOCK_RESONATE, 1.0f, 1.5f);
        DeviceItem.clearValue(stack);
    }
}

