/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.item;

import com.google.common.base.Suppliers;
import galena.oreganized.Oreganized;
import galena.oreganized.index.OArmorMaterials;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class ElectrumArmorItem
extends ArmorItem {
    private static final ResourceLocation TEXTURE = Oreganized.modLoc("textures/entity/electrum_armor.png");
    private final Supplier<ItemAttributeModifiers> modifiers = Suppliers.memoize(() -> {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        ArmorMaterial material = (ArmorMaterial)OArmorMaterials.ELECTRUM.value();
        EquipmentSlotGroup slotGroup = EquipmentSlotGroup.bySlot((EquipmentSlot)slot.getSlot());
        ResourceLocation id = ResourceLocation.withDefaultNamespace((String)("armor." + slot.getName()));
        builder.add(Attributes.ARMOR, new AttributeModifier(id, (double)material.getDefense(slot), AttributeModifier.Operation.ADD_VALUE), slotGroup);
        builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(id, (double)material.toughness(), AttributeModifier.Operation.ADD_VALUE), slotGroup);
        builder.add(Attributes.MOVEMENT_SPEED, new AttributeModifier(id, 0.05, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), slotGroup);
        return builder.build();
    });

    public ElectrumArmorItem(ArmorItem.Type slot) {
        super(OArmorMaterials.ELECTRUM, slot, new Item.Properties().durability(slot.getDurability(33)));
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return this.modifiers.get();
    }

    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        return TEXTURE;
    }
}

